require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'

include Axure::DocumentModel
include Axure::Platform::Controls

# use for Wireframe->Manage Raise Events and for Interaction Case Editor: Raise Event action
class RaiseEventActionEditor < AML::Control
  attr_reader :event_list
  bindable_attr_writer :event_list

  def initialize()
    #allow AlignPadLayouPanel to size up to its containing control
    self.auto_size = true

    initialize_component("dialogs/raise_event_action_editor.aml")
  end

  def dialog_info=(_info)
    self.master = _info.properties["Master"]
    _info.title = intl_str("Manage Raised Events")

    _info.default_size = AxSizeF.new(450,350)
    _info.min_size = AxSizeF.new(350,300)
  end

  def master=(master)
    @master = master
    @event_list.has_check_box = false
    update_list
  end

  #for interaction case editor
  def raise_event_action=(action)
    @raise_event_action = action
    @event_list.has_check_box = true
    update_list
  end

  def update_list
    select_objects = []
    for event_info in @master.raised_event_infos
      prop_name = PropertyName.new(nil)
      prop_name.name = event_info.name
      prop_name.property_name_id = event_info.raised_event_info_id

      s_obj = SelectObject.new(nil, prop_name, false)
      s_obj.selected = @raise_event_action.contains_raised_event_info_id(event_info.raised_event_info_id) if @raise_event_action

      select_objects << s_obj
    end

    if select_objects.length != 0
      @event_list.select_objects = select_objects.to_clr_list
    else
      @event_list.select_objects = nil
    end

  end


  def get_selected_info
    if @event_list.current_select_object
      id = @event_list.current_select_object.object.property_name_id;

      @master.raised_event_infos.each { | e_info |
        return e_info if e_info.raised_event_info_id == id
      }
    end
    return nil
  end

  def add_clicked(s, e)
    @master.AddRaisedEvent(next_name(intl_str("NewEvent"), @master.raised_event_names));
    update_list();

    @event_list.selected_index = @event_list.get_control_count() - 1
    @event_list.edit_selected_item()
  end

  def is_valid_raised_event_name(name)
    return false if @master.GetRaisedEventByName(name) != nil
    return false if name.length > 25
    return false if (/^[a-zA-Z0-9]*$/).match(name) == nil
    return false if name.index(" ") != nil

    return true;
  end

  def remove_clicked(s, e)
    if AxPlatform.PlatformServices.ShowMessageBox(
      intl_str("Are you sure you want to delete this event?\nIt cannot be undone."),
      intl_str("Warning"), AxMessageBoxButtons.YesNo) == AxDialogResult.Yes

      event_info = get_selected_info()
      if event_info
        @raise_event_action.RemoveRaisedEventInfoId(event_info.RaisedEventInfoId) if @raise_event_action
        @master.RemoveRaisedEvent(event_info);
        update_list();
        @event_list.refresh_selection()
      end
    end
  end

  def event_name_edit_finished(s, e)
    new_name = e.control.get_attached_property(ListPanel[].EDITING_TEXT)
    old_name = e.control.text
    return if new_name == old_name

    if (new_name.length > 0 && is_valid_raised_event_name(new_name) )
      get_selected_info.name = new_name
      e.control.text = new_name
    else
      if AxPlatform.PlatformServices.ShowMessageBox(
              intl_str("The event name is invalid or in use. Please try again.\nClick Cancel or Press Esc while editing to revert the name"),
              intl_str("Invalid Name"), AxMessageBoxButtons.o_k_cancel) == AxDialogResult.o_k
        e.Handled = false
      else
        e.control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
      end
    end
  end
#
#  def rename_clicked(s, e)
#    event_info = get_selected_info()
#    if event_info
#      selected_item = @event_list.selected_item
#
#      content = StackLayoutPanel.new
#      content.width = 150
#
#      l = AxLabel.new
#      l.text = intl_str("Rename #{event_info.name} to:")
#
#      tb = AxTextBox.new
#      tb.auto_size = true
#      tb.text = event_info.name
#      tb.allow_edit = true
#
#      ok = SimpleButton.new
#      ok.text = intl_str("OK")
#      ok.width = 60
#      ok.clicked.add(lambda {|s, e|
#        if (tb.text.length > 0 &&
#            is_valid_raised_event_name(tb.text) )
#            event_info.name = tb.text
#            selected_item.text = tb.text
#            selected_item.host.hide_pop_up_container()
#        else
#          AxPlatform.PlatformServices.ShowMessageBox(
#            intl_str("The event name is invalid or in use. Please try again.\nPress Esc to cancel the edit and revert the name."));
#        end
#
#      } )
#
#      cancel = SimpleButton.new
#      cancel.auto_size = true
#      cancel.text = intl_str("Cancel")
#      cancel.clicked.add(lambda {|s, e|
#        selected_item.host.hide_pop_up_container()
#      } )
#
#      buttons = StackLayoutPanel.new
#      buttons.vertical = false
#      buttons.height = 26
#      buttons.add_controls(ok, cancel)
#
#      content.add_controls(l, tb, buttons )
#
#      popup_info = PopupContainerInfo.new
#      popup_info.popup_content = content
#      popup_info.allows_focus = true
#      popup_info.works_when_modal = true
#
#
#      selected_item.show_pop_up_container(popup_info)
#    end
#
#  end

  def moveup_clicked(s, e)
    @master.move_raised_event_info(get_selected_info, -1)
    @event_list.move_up()
  end

  def movedown_clicked(s, e)
    @master.move_raised_event_info(get_selected_info, 1)
    @event_list.move_down()
  end

  def event_list_item_checked(sender, args)
    if @raise_event_action
      if @event_list.selected_item.selected
        @raise_event_action.add_raised_event_info_id(get_selected_info().raised_event_info_id)
      else
        @raise_event_action.remove_raised_event_info_id(get_selected_info().raised_event_info_id)
      end
    end
  end
end
