require 'aml'

class RadioButtonGroupDialog < AML::Control
  attr_reader :config
  bindable_attr_writer :config

  def my_init()
    self.config = @info["configuration"]

    @info.before_close.add(lambda { @config.selected_group = @list.text })
  end

  def dialog_info=(value)
    @info = value
    @info.set_fixed_size(AxSizeF.new(260, 80))
    @info.before_shown.add(lambda { @list.focus })
    my_init()
  end

  def initialize()
    initialize_component('dialogs/radio_button/group_dlg.aml')
  end
end