require 'aml'
require 'Model'

require 'dialogs/package_edit_control'

include Axure::DocumentModel

class PageNotesDialog < PackageEditControl
  attr_reader :notes
  bindable_attr_writer :notes

  def dialog_info=(value)
    @info = value
    @info.default_size = AxSizeF.new(250,250)
    @info.min_size = AxSizeF.new(250,250)
    @info.before_shown.add(lambda { @notes.focus })

		self.field_set=@info["fieldSet"];
  end

  def initialize()
    initialize_component('dialogs/page_notes_dlg/page_notes_dlg.aml')
  end

	def field_set=(value)
    @field_set = value

		@package_object = @field_set

    @prop_key = @field_set.property_key
    @view_key = @field_set.annotation_field_views

    my_init()
	end

  def my_init()
    suspend_layout()

    reset_notes()
    resume_layout()

    set_remove_button_tooltip
  end

  def reset_notes
    @notes.suspend_layout()
    @notes.clear_controls()
    @notes.string_items = @prop_key.key_names
    @notes.resume_layout()
  end

  def add_button_clicked
    @prop_key.add_property(next_name(intl_str("New Note"), @prop_key.key_names), DocumentDataType.text)
    reset_notes()

    @notes.selected_index = @notes.get_control_count() - 1
    @notes.edit_selected_item()
  end

  def remove_button_clicked
    @prop_key.delete_property(@notes.selected_item.text)
    reset_notes()
    @notes.refresh_selection()
    set_remove_button_tooltip
  end

  def up_button_clicked
    old_index = @notes.selected_index
    if @prop_key.move_property(@notes.selected_item.text, -1)
      reset_notes()
      @notes.selected_index = old_index - 1
    end
  end

  def down_button_clicked
    old_index = @notes.selected_index
    if @prop_key.move_property(@notes.selected_item.text, 1)
      reset_notes()
      @notes.selected_index = old_index + 1
    end
  end

  def field_edit_finished(sender, e)
    control = e.control
    new_name = control.get_attached_property(ListPanel[].EDITING_TEXT)
    old_name = control.text
    return if new_name == old_name

    if(!is_valid_name(new_name, @prop_key.key_names))
#      AxPlatform.platform_services.show_message_box(
#              intl_str("The notes name is invalid or in use. Please try again."))
#      control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
      if AxPlatform.PlatformServices.ShowMessageBox(
              intl_str("The notes name is invalid or in use. Please use another.\nClick Cancel or Press Esc while editing to revert the name"),
              intl_str("Invalid Name"), AxMessageBoxButtons.o_k_cancel) == AxDialogResult.o_k
        e.Handled = false
      else e.control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
      end
    else
      @prop_key.rename_property(old_name, new_name)
#      i can't do this through the normal reset_notes method because it might mess up the scroll
#      reset_notes()
      control.text = new_name
    end
  end

  def is_valid_name(name, name_array)
    return false if name.empty?() || name.include?("\"")

    name_array.each do |val|
      return false if name == val
    end

    return true
  end

  def notes_selected_index_changed
    set_remove_button_tooltip()
  end

  def set_remove_button_tooltip
    if (!@notes.selected_item || @notes.get_control_count > 1): @remove_button.tool_tip = intl_str("Remove")
    else @remove_button.tool_tip = intl_str("There must be at least one set of notes.")
    end
  end

	#region IPackageEditControl overrides
	def RefreshContent
		@client.CurrentFile.Refresh();
		self.field_set = @client.Document.PageFragmentAnnotationFieldSet;
	end

	def SaveContent
		super

		@client.CurrentFile.Refresh();
	end
	#endregion IPackageEditControl overrides
end
