require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'

include Axure::DocumentModel
include Axure::Platform::Controls

# these controls are:
# html prototype generator, w2007 spec generator,
# global var editor, page notes, cust fields
class PackageEditControl < AML::Control
	include Axure::Client::WindowlessControls::IPackageEditControl

	attr_reader :client, :disable_package_edit, :enable_package_edit
	attr_writer :client
	bindable_attr_writer :enable_package_edit


	#region IPackageEditControl implementation
	def associated_package_id
		return @package_object.package_id
	end

	def RefreshContent
	end

	def SaveContent
		if @client.CurrentFile.Team.IsTeamProject
			teamInfo = @client.CurrentFile.Team.GetTeamPackageInfo(@package_object.PackageId)
			if (teamInfo.IsNew || teamInfo.IsCheckOut || teamInfo.IsUnsafeCheckOut)
				@client.CurrentFile.SavePackage(@package_object)
			end
		else
			@client.CurrentFile.SavePackage(@package_object)
		end
	end

	def disable_package_edit=(value)
		@disable_package_edit = value

		self.enable_package_edit = !value
	end
	#endregion IPackageEditControl implementation

end
