require 'aml'
require 'interop'

class MasterUsageDialog < AML::Control
  attr_reader :configuration
  bindable_attr_writer :configuration

  def my_init()
    self.configuration = @info["configuration"]

    @header_label.text += "  " + configuration.current_document.get_package_info(configuration.master_id).package_name

    update_dependency_list()
  end

  def update_dependency_list
    doc = configuration.current_document
    @hash = doc.package_name_to_id_containing_master(configuration.master_id)

    @page_list.string_items = @hash.keys
  end

  def dialog_info=(value)
    @info = value
    @info.default_size = AxSizeF.new(250,300)
    @info.min_size = AxSizeF.new(250,250)
    @info.before_shown.add(lambda { @page_list.focus })

    my_init()
  end

  def page_list_item_selected(sender, e)
    e.Handled = true
    configuration.package_id_to_edit = @hash[e.control.text]
    @info.click_ok
  end

  def initialize()
    initialize_component('dialogs/masters/master_usage_dlg.aml')
  end
end