require 'aml'

class ConvertToMasterDialog < AML::Control
  attr_reader :info
  bindable_attr_writer :info

  def initialize()
    initialize_component('dialogs/masters/convert_to_master_dlg.aml')
  end

  def dialog_info=(_info)
    self.info = _info
    @message_label.Text = _info.warning_message    
    info.title = intl_str("Convert To Master")
    info.o_k_button_text = intl_str("Continue")
    info.default_size = AxSizeF.new(400, 190)
    info.min_size = AxSizeF.new(400, 190)
    info.before_shown.add(lambda { @name_box.focus; @name_box.select_all })
  end
end