require 'aml'

include Axure::Client::ToolBoxes::Components::PagesAndMasters

class ApplyMastersDialog < AML::Control
  attr_reader :configuration, :location_button
  bindable_attr_writer :configuration

  def my_init()
    self.configuration = @info["configuration"]
  end

  def dialog_info=(value)
    @info = value
    @info.default_size = AxSizeF.new(300,400)
    @info.min_size = AxSizeF.new(300,350)
    
    @info.before_close.add(lambda { configuration.page_ids = @page_tree.checked_ids} )
#    @info.my_test_method()

    my_init()
  end

  def initialize()
    initialize_component('dialogs/masters/apply_masters_dlg.aml')
  end

  def generate_all_selected_changed
    if @generate_all_button.selected: @tree_grid.enabled = false
    else @tree_grid.enabled = true
    end
  end

  def check_all_clicked
    @page_tree.check_all
  end

  def uncheck_all_clicked
    @page_tree.uncheck_all
  end

  def check_all_children_clicked
    node = @page_tree.current_node
    if (node != nil)
      @page_tree.check_children(node)
    end
  end

  def uncheck_all_children_clicked
    node = @page_tree.current_node
    if (node != nil)
      @page_tree.uncheck_children(node)
    end
  end

  def tree_checked_node_changed
  end

  def tree_current_node_changed
  end

end