require 'aml'
require 'Model'
require 'interop'

include Axure::DocumentModel
include Axure::DocumentModel::Objects

class ListEditDialog < AML::Control
  attr_reader :items, :list_object, :options, :allow_multiple_button
  bindable_attr_writer :items, :list_object, :options, :allow_multiple_button

  def dialog_info=(value)
    @info = value
    value.default_size = AxSizeF.new(300,300)
    value.min_size = AxSizeF.new(250,250)

    my_init()
  end

  def initialize()
    initialize_component('dialogs/list_edit_dlg/list_edit_dlg.aml')
  end

  def my_init()
    self.list_object = @info["listObject"]
    self.options = List[SelectObject].new(@list_object.deep_copy_options)
    @diagram_editor = @info["diagramEditor"]
    @info.before_close.add(lambda { |sender, e| before_close(sender, e) })

    @allow_multiple_button.visible = list_object.is_a?(ListBox)

    refresh_buttons
  end

  def select_object_names
    options.collect { |select_object| select_object.text_value }
  end

  def add_button_clicked
    next_name = next_name(intl_str("List Item"), select_object_names)
    index = @items.selected_index
    index = @items.get_control_count() - 1 if index == -1
    @items.insert_new_select_object(index + 1, SelectObject.new(list_object.owner, System::String.new(next_name), false))

    @items.selected_index = index + 1
    @items.edit_selected_item

    refresh_buttons
  end

  def add_many_button_clicked
      add_many_dialog = Axure::Client::Dialogs::RubyDialogInfo.new
      add_many_dialog.script_name = "dialogs/add_many_dlg/add_many_dlg.rb"
      add_many_dialog.class_name = "AddManyDialog"
      add_many_dialog.title = intl_str("Add Many")

      if (add_many_dialog.show_dialog == AxDialogResult.o_k)
        index = @items.selected_index
        index = @items.get_control_count() - 1 if index == -1

        item_inserted = false
        list_text = add_many_dialog[:list_text]

        list_text = list_text.replace("\r\n", "\n")
        list_text = list_text.replace("\r", "\n")

        list_text.split("\n").each { |item_name|
          if (item_name.length > 0)
            @items.insert_new_select_object(index + 1, SelectObject.new(list_object.owner, System::String.new(item_name), false))
            index = index + 1
            item_inserted = true
          end
        }

        @items.selected_index = index if item_inserted
        refresh_buttons
      end
  end

  def remove_button_clicked
    @items.remove_item(@items.selected_item)
    @items.refresh_selection

    refresh_buttons
  end

  def remove_all_button_clicked
    @items.clear_controls
    @items.refresh_selection

    refresh_buttons
  end

  def up_button_clicked
    @items.move_up
  end

  def down_button_clicked
    @items.move_down
  end

  def default_button_clicked
    set_default_item
  end

  def set_default_item
    @items.toggle_selected_item()
    refresh_buttons
  end

  def items_selected_index_changed
    refresh_buttons
  end

  def refresh_buttons
    selected_item = @items.selected_item
    if(selected_item && !selected_item.selected): @default_button.tool_tip = intl_str("Set this item selected by default")
    else @default_button.tool_tip = intl_str("Set this item unselected by default")
    end
    @remove_all_button.enabled = @items.get_control_count > 0
  end

  def items_edit_finished(sender, e)
    control = e.control
    new_name = control.get_attached_property(ListPanel[].EDITING_TEXT)
    old_name = control.text
    return if new_name == old_name

    if(!is_valid_name(new_name))
#      AxPlatform.platform_services.show_message_box(intl_str("The name is invalid. Please try again."))
      control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
    else
      options[@items.selected_index].text_value = new_name
      control.text = new_name
    end
  end

  def is_valid_name(name)
    name.length > 0
  end

  def before_close(sender, e)
    if (@info.dialog_result == AxDialogResult.o_k)
      @diagram_editor.apply_edit(ListObjectEdit.new(list_object, options, @allow_multiple_button.selected))
    end
  end
end
