require 'aml'
require 'dialogs/interaction_editor_dlg/interaction_properties_editor'

include Axure::Client::Common
include Axure::Client::Common::TreeView
include Axure::DocumentModel::Interaction

#base class for widgets editors, and dynamic panel editors
class WidgetActionEditor <  AML::Control

	#return @widget_action is InteractionDiagramObjectPathsAction
	def is_dobj_path_action
		return @widget_action.is_a?(Axure::DocumentModel::Interaction::InteractionDiagramObjectPathsAction)
	end

	def initialize(diagram, widget_action)

		initialize_component("dialogs/interaction_editor_dlg/widget_action_editor.aml")

		@diagram = diagram
		@widget_action = widget_action

		@widget_treeview.has_check_box = true
		@widget_treeview.diagram = diagram
		@widget_treeview.diagram_object_filter = System::Predicate[DiagramObject].new do |dobj|
			diagram_object_filter(dobj)
		end
		@widget_treeview.tree_node_generator = @custom_treenode_generator
		@widget_treeview.node_expanded.add(
			lambda { |sender, event_args|
              if self.is_dobj_path_action
				tn = event_args.control
				for child in tn.depth_first_descendants do
						child.checked_state = AxCheckButtonState.selected if @widget_action.contains_path(child.diagram_object_path)
    			end
			  end
		})

		@widget_treeview.hide_empty_master = true
		@widget_treeview.hide_empty_dynamic_panel = @hide_empty_dynamic_panel
		@widget_treeview.include_objects_in_master = true
		@widget_treeview.include_objects_in_dynamic_panel = true
		@widget_treeview.dynamic_panel_selectable = @dynamic_panel_selectable
		@widget_treeview.diagram_object_collection = @diagram.diagram_objects
		@widget_treeview.update_tree_view

		if self.is_dobj_path_action
            dop_to_remove_list = System::Collections::Generic::List[Axure::DocumentModel::DiagramObjectPath].new
			for diagram_object_path in @widget_action.diagram_object_paths
				tn = @widget_treeview.get_tree_node_by_diagram_object_path(diagram_object_path)
				if (tn)
                  tn.checked_state = AxCheckButtonState.selected
                else
                  dop_to_remove_list.add(diagram_object_path)
                end
            end
            for diagram_object_path in dop_to_remove_list
				@widget_action.remove_path(diagram_object_path)
            end
		end

	end

	def diagram_object_filter(diagram_object)
		return true
	end

	def widget_treeview_checked_node_changed(sender, event_args)
		tn = event_args.control
		if tn.checked_state == AxCheckButtonState.selected
			if @is_single_widget_action
				for checked_tn in @widget_treeview.checked_nodes
					if checked_tn != tn
						checked_tn.checked_state = AxCheckButtonState.unselected
					end
				end
			end
			#for @widget_action is InteractionDiagramObjectPathsAction
			#otherwise override this function
			@widget_action.add_path(tn.diagram_object_path) if self.is_dobj_path_action
		else
			@widget_action.remove_path(tn.diagram_object_path) if self.is_dobj_path_action
		end
	end

	def search_textchanged(s, e)
		@widget_treeview.search( lambda { | treenode | treenode.text.downcase.include?(@search_textbox.text.downcase)} )
	end

end

class EnableWidgetsActionEditor < WidgetActionEditor
	def initialize(diagram, widget_action)
		@enable_disable_types = [
			AxureType::DiagramObject.Checkbox, AxureType::DiagramObject.RadioButton, AxureType::DiagramObject.TextBox,
			AxureType::DiagramObject.TextArea, AxureType::DiagramObject.ListBox, AxureType::DiagramObject.ComboBox,
			AxureType::DiagramObject.Button, AxureType::DiagramObject.ButtonShape, AxureType::DiagramObject.ImageBox,
		]
		@hide_empty_master = true
		@hide_empty_dynamic_panel = true

		super(diagram, widget_action)

		@help_label.text = intl_str("Select widget to enable.")
	end

	def diagram_object_filter(diagram_object)
		retVal = @enable_disable_types.include?(diagram_object.type_name)
		return retVal
	end
end

class DisableWidgetsActionEditor < WidgetActionEditor
	def initialize(diagram, widget_action)
		@enable_disable_types = [
			AxureType::DiagramObject.Checkbox, AxureType::DiagramObject.RadioButton, AxureType::DiagramObject.TextBox,
			AxureType::DiagramObject.TextArea, AxureType::DiagramObject.ListBox, AxureType::DiagramObject.ComboBox,
			AxureType::DiagramObject.Button, AxureType::DiagramObject.ButtonShape, AxureType::DiagramObject.ImageBox,
		]
		@hide_empty_master = true
		@hide_empty_dynamic_panel = true

		super(diagram, widget_action)

		@help_label.text = intl_str("Select widget to disable.")
	end

	def diagram_object_filter(diagram_object)
		return @enable_disable_types.include?(diagram_object.type_name)
	end
end

class SetFocusOnWidgetActionEditor < WidgetActionEditor
	def initialize(diagram, widget_action)
		@is_single_widget_action = true
		@focusable_types = [
			AxureType::DiagramObject.Checkbox, AxureType::DiagramObject.RadioButton,
			AxureType::DiagramObject.TextBox, AxureType::DiagramObject.TextArea,
			AxureType::DiagramObject.ListBox, AxureType::DiagramObject.ComboBox,
			AxureType::DiagramObject.Button, AxureType::DiagramObject.ImageBox,
			AxureType::DiagramObject.ImageMapRegion, AxureType::DiagramObject.ButtonShape,
		]
		@hide_empty_master = true
		@hide_empty_dynamic_panel = true

		super(diagram, widget_action)

		@help_label.text = intl_str("Select widget to focus.")
	end

	def diagram_object_filter(diagram_object)
		return @focusable_types.include?(diagram_object.type_name)
	end
end

class ExpandWidgetsActionEditor < WidgetActionEditor
	def initialize(diagram, widget_action)
		@filter = [ AxureType::DiagramObject.TreeNodeObject ]
		@hide_empty_master = true
		@hide_empty_dynamic_panel = true

		super(diagram, widget_action)
		@help_label.text = intl_str("Select treenode(s) to expand")
	end

	def diagram_object_filter(diagram_object)
		return @filter.include?(diagram_object.type_name)
	end
end

class CollapseWidgetsActionEditor < WidgetActionEditor
	def initialize(diagram, widget_action)
		@filter = [ AxureType::DiagramObject.TreeNodeObject]
		@hide_empty_master = true
		@hide_empty_dynamic_panel = true

		super(diagram, widget_action)
		@help_label.text = intl_str("Select treenode(s) to collapse")
	end

	def diagram_object_filter(diagram_object)
		return @filter.include?(diagram_object.type_name)
	end
end

class ScrollToWidgetActionEditor < WidgetActionEditor
	def initialize(diagram, widget_action)
		@is_single_widget_action = true
		@filter = [ AxureType::DiagramObject.ImageMapRegion]
		@hide_empty_master = true
		@hide_empty_dynamic_panel = true

		super(diagram, widget_action)

        @widget_treeview.node_expanded.add(
            lambda { |sender, event_args|
                tn = event_args.control
                for child in tn.depth_first_descendants do
                    child.checked_state = AxCheckButtonState.selected if @widget_action.target_widget_path && @widget_action.target_widget_path == child.diagram_object_path
            end
        })

		@help_label.text = intl_str("Select image map region")

		#add scroll options
		options_radio_group = AxRadioGroup.new
        radio_stack = StackLayoutPanel.new
        radio_stack.spacing = 5
        options_radio_group.add_control(radio_stack)
		@vertical_radio_button = options_radio_group.add_radio_button(AxCheckButtonState.selected,
																																	intl_str("Scroll vertically only"))
		@horizontal_radio_button = options_radio_group.add_radio_button(AxCheckButtonState.unselected,
																																	 	intl_str("Scroll horizontally only"))
		@both_dir_radio_button = options_radio_group.add_radio_button(AxCheckButtonState.unselected,
																																	intl_str("Scroll vertically and horizontally"))
		if @widget_action.target_widget_path
			tn = @widget_treeview.get_tree_node_by_diagram_object_path(@widget_action.target_widget_path)
			tn.checked_state = AxCheckButtonState.selected if tn

			case @widget_action.direction
			when ScrollToWidgetDirection.y
				@vertical_radio_button.selected = true
			when ScrollToWidgetDirection.x
				@horizontal_radio_button.selected = true
			when ScrollToWidgetDirection.xy
				@both_dir_radio_button.selected = true
			end
		end

		options_radio_group.selected_control_changed.add(lambda {|s,e| options_changed(s,e)})
		@stack_layout_panel.add_control(options_radio_group)
	end

	def options_changed(sender, event_args)
		case event_args.control
		when @vertical_radio_button
			@widget_action.direction = ScrollToWidgetDirection.y
		when @horizontal_radio_button
			@widget_action.direction = ScrollToWidgetDirection.x
		when @both_dir_radio_button
			@widget_action.direction = ScrollToWidgetDirection.xy
		end
	end

	def diagram_object_filter(diagram_object)
		return @filter.include?(diagram_object.type_name)
	end

	def widget_treeview_checked_node_changed(sender, event_args)
		super(sender, event_args)
		tn = event_args.control

		if tn.checked_state == AxCheckButtonState.selected
			@widget_action.target_widget_path = event_args.control.diagram_object_path
		else
			@widget_action.target_widget_path = nil
		end
	end
end

class SetWidgetsToPropertySetActionEditor < WidgetActionEditor
    class SetPropertyEditor < AML::Control
      def initialize()
        initialize_component("dialogs/interaction_editor_dlg/set_property_editor.aml")

        toby = System::Array[System::String].new(3)
        toby[0] = intl_str("Default")
        toby[1] = intl_str("Selected")
        toby[2] = intl_str("Toggle Selected")
        @state_select_list.string_items = toby
      end

      def tree_node=(tree_node)
        @current_tree_node = tree_node
        if !@current_tree_node
          @state_grid.enabled = false
          return
        end

        @state_grid.enabled = true
        #@state_select_list.string_items = @current_tree_node.property_strings
        @state_select_list.selected_index = @current_tree_node.current_property_index

      end

      def state_select_list_item_selected(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetCurrentPropertyIndex(@state_select_list.selected_index)
        end
      end
    end


	def initialize(diagram, widget_action)
        @filter = [AxureType::DiagramObject.ImageBox, AxureType::DiagramObject.ButtonShape, AxureType::DiagramObject.Menu, AxureType::DiagramObject.TableCell, AxureType::DiagramObject.TreeNodeObject]
        @hide_empty_master = true
		@hide_empty_dynamic_panel = true

		@custom_treenode_generator = lambda {|dobj, parent_node| generate_tree_node(dobj, parent_node)}

		super(diagram, widget_action)

        @widget_treeview.node_expanded.add(
            lambda { |sender, event_args|
                tn = event_args.control
                for child in tn.depth_first_descendants do
                    child.checked_state = AxCheckButtonState.selected if @widget_action.contains_widget_to_property_value_set_association(child.diagram_object_path)
            end
        })

        dop_to_remove_list = System::Collections::Generic::List[Axure::DocumentModel::DiagramObjectPath].new
		for dpp in @widget_action.widget_to_property_set_type.keys
			tn = @widget_treeview.get_tree_node_by_diagram_object_path(dpp)
			if (tn)
              tn.checked_state = AxCheckButtonState.selected
            else
              dop_to_remove_list.add(dpp)
            end
		end
        for dpp in dop_to_remove_list
            @widget_action.RemoveWidgetToPropertyValueSet(dpp)
        end

        @widget_treeview.checked_node_changed.add(lambda { |s, e| widget_treeview_checked_node_changed(s,e) })
        @widget_treeview.current_node_changed.add(lambda { |s, e| widget_treeview_current_node_changed(s,e) })

		@help_label.text = intl_str("Select the widgets to set the selected state")

        @set_property_editor = SetPropertyEditor.new()
        @set_property_editor.tree_node =nil
        @set_property_editor.desired_height = 40
        @stack_layout_panel.add_control(@set_property_editor)
	end

	def generate_tree_node(dobj, parent_node)
		tn = SetWidgetStateTreeNode.new
		tn.diagram = @widget_treeview.diagram
		tn.diagram_object = dobj
		tn.set_widget_state_action = @widget_action
		tn.parent_tree_view = @widget_treeview
		return tn
    end

    def diagram_object_filter(diagram_object)
		return @filter.include?(diagram_object.type_name)
    end

    def widget_treeview_checked_node_changed(sender, event_args)
		super(sender, event_args)
		tn = event_args.control

        if (tn != @widget_treeview.current_node)
          return
        end

        if (@set_property_editor)
          if tn && tn.checked_state == AxCheckButtonState.selected
              @set_property_editor.tree_node = tn
          else
              @set_property_editor.tree_node =nil
          end
        end
	end

	def widget_treeview_current_node_changed(sender, event_args)
		tn = @widget_treeview.current_node
		if tn && tn.checked_state == AxCheckButtonState.selected
			@set_property_editor.tree_node = tn
		else
			@set_property_editor.tree_node =nil
		end
	end
end

