require 'aml'

class PanelToStateCheckButton < AML::Control
	def initialize(dp_action, dp, dobj_path)
		#self.auto_size = true
		initialize_component('dialogs/interaction_editor_dlg/panel_to_state_check_button.aml')

		@panel_name_label.text = dp.display_name
		@dp_action = dp_action
		@dobj_path = dobj_path

		@label_to_pd_id = Hash.new
		@pd_id_to_label = Hash.new

		for pd in dp.panel_diagrams
			lb = AxLabel.new
			lb.Text = pd.name	
			@panel_state_list.add_select_list_item(lb)
			@label_to_pd_id[lb] = pd.unique_identifier
			@pd_id_to_label[pd.unique_identifier] = lb
		end

		if @dp_action.contains_panel_path_to_diagram_association(@dobj_path)
			@chk_button.state = AxCheckButtonState.selected
			pd = @dp_action.get_state(@dobj_path)
			@panel_state_list.string_value = pd.name
		end


		self.size = AxSize.new(200, 20)
		@chk_button.size = AxSize.new(200, 20)
	end
	
	def indent=(indent)
		self.margins = Borders.new(indent *18, self.padding.top, self.padding.right, self.padding.bottom);
		#self.size = AxSize.new(self.width+16, self.height)
	end

	def chk_button_selected_changed(sender, e)
		if sender.state == AxCheckButtonState.selected
			@panel_state_list.enabled = true
			if !@dp_action.contains_panel_path_to_diagram_association(@dobj_path)
				@dp_action.add_panel_path_to_diagram_association(@dobj_path)
				@panel_state_list.string_value = @dp_action.get_state(@dobj_path).name
			end
			@panel_state_list.string_value = @dp_action.get_state(@dobj_path).name
		else
			@panel_state_list.enabled = false
			if @dp_action.contains_panel_path_to_diagram_association(@dobj_path)
				@dp_action.remove_panel_path_to_diagram(@dobj_path)
			end
		end
	end

	def state_list_item_selected(sender, e)
		state_id = @label_to_pd_id[@panel_state_list.selected_item]
		@dp_action.set_panel_path_to_diagram_association(@dobj_path, state_id)
	end
end
