require 'aml'
require 'axure_enumerable'
require 'Model'
require ('dialogs/interaction_editor_dlg/interaction_properties_editor')
require 'interop'

include Axure::DocumentModel
include Axure::Platform::Controls

class ExprActionEditor < InteractionPropertiesEditor
	def initialize(client, diagram, action)
		super(action)
		@diagram = diagram
		@action = action
        @client = client
	end

	def button_clicked(sender, e)
		info = Axure::Client::Dialogs::WindowlessDialogInfo.new
        info.title = intl_str("Set Variable and Widget Values")
        info.default_size = AxSizeF.new(790, 400)
        info.min_size = AxSizeF.new(640, 360)

		ead = Axure::Client::Interaction::ExprActionDialog.new(info)
		ead.client = @client
        ead.diagram = @diagram
		ead.expression = @action.action

#		info.dialog = ead
#      info.min_size = AxSizeF.new(800,400)

		if info.show_dialog() == AxDialogResult.OK
			@action.action = ead.expression
        end
	end
end

class OtherActionEditor < InteractionPropertiesEditor
	def initialize(other_action)
		super
		self.size = AxSize.new(400, 200)
		@other_action = other_action
		@textbox.text = other_action.action_description
	end

	def textbox_text_changed(sender, event_args)
		@other_action.action_description = @textbox.text
	end

end

class WaitActionEditor < InteractionPropertiesEditor
	def initialize(wait_action)
		super
		self.size = AxSize.new(400, 50)
		@wait_action = wait_action
		@numberbox.value= wait_action.wait_time
	end

	def numberbox_value_changed(sender, args)
		@wait_action.wait_time = @numberbox.value
	end
end
