require 'aml'
require 'Model.dll'
require 'dialogs/interaction_editor_dlg/interaction_properties_editor'

include Axure::Client::ToolBoxes::Components::PagesAndMasters
include Axure::DocumentModel::Interaction

class LinkEditor < AML::Control
	def initialize()
		self.anchor = Position.all
		initialize_component("dialogs/interaction_editor_dlg/link_editor.aml")
		self.size = AxSize.new(350, 350)

		@link_radio_group.enabled = false
		@link_radio_group.remove_control(@link_reload) unless @allow_reload
		@link_radio_group.remove_control(@link_back) unless @allow_back
	end

	def target=(target)
		@current_target = target
		if !@current_target
			@link_radio_group.enabled = false
			@link_radio_group.selected_control = nil
			return
		end

		@page_treeview.current_node = nil
		@link_radio_group.enabled = true

		if @page_treeview.current_document == nil
			#we only need to do this once
			#saves some time updating the tree
			@page_treeview.current_document = @current_target.parent_document
			@page_treeview.current_tree_map = @current_target.parent_document.sitemap
		end

		case @current_target.target_type
		when InteractionTargetType.Page
			@link_page.selected = true
			@page_treeview.current_package_id = @current_target.target_page_package_id
		when InteractionTargetType.WebUrl
			if @current_target.hyperlink.length > 0
				@link_url.selected = true
			else
				@link_page.selected = true
			end
		when InteractionTargetType.ReloadPage
			@link_reload.selected = true
		when InteractionTargetType.BackUrl
			@link_back.selected = true
		end

		set_hyperlink_textbox
	end

    def dialog_info=(dialog_info)
      @dialog_info = dialog_info
    end

    def page_treeview_node_double_clicked(sender, event_args)
      if (@dialog_info != nil)
        if !@page_treeview.current_node
			 return
		end

		@link_textbox.text = @page_treeview.current_node.package_info.package_name + ".html"
		@current_target.target_page_package_id = @page_treeview.current_package_id

        @dialog_info.click_ok
      end
    end

	def page_treeview_current_node_changed(sender, event_args)
		if !@page_treeview.current_node
			 return
		end

		@link_textbox.text = @page_treeview.current_node.package_info.package_name + ".html"
		@current_target.target_page_package_id = @page_treeview.current_package_id
	end

	def link_textbox_textchanged(sender, event_args)
		@current_target.hyperlink = @link_textbox.text
	end

	def set_hyperlink_textbox
		if @link_page.selected
		 	if @page_treeview.current_package_id != System::Guid.Empty
				@link_textbox.text = @page_treeview.current_node.package_info.package_name + ".html"
			else
				@link_textbox.text = ""
			end
		else
				@link_textbox.text = @current_target.hyperlink_display
		end

	end

	def selected_control_changed(sender, event_args)
		selected = event_args.control

		@page_treeview.enabled = false
		@link_textbox.enabled = false
		@page_treeview.current_node = nil

		if !@current_target
			return
	 	end

		case selected
		when @link_page #in aml
			newtype = InteractionTargetType.Page
			@page_treeview.enabled = true
            @page_treeview.current_package_id = @current_target.target_page_package_id
		when @link_url
			newtype = InteractionTargetType.WebUrl
			@link_textbox.enabled = true
		when @link_reload
			newtype = InteractionTargetType.ReloadPage
		when @link_back
			newtype = InteractionTargetType.BackUrl
		end

		@current_target.target_type = newtype

		set_hyperlink_textbox
	end

    def hide_reload_and_back()
      @link_reload.visible = false;
      @link_back.visible = false;
    end
end

class LinkCurrentActionEditor < LinkEditor
	def initialize(link_current_action)
		@allow_reload = true
		@allow_back = true
		super()
		self.target=link_current_action.target

		#@help_label.Text=intl_str("Link in Current")
	end

end

class LinkNewTabActionEditor < LinkEditor
	def initialize(link_new_tab_action)
		super()
		self.target=link_new_tab_action.target

		#@help_label.Text=intl_str("Link parent window")
	end
end

class LinkParentActionEditor < LinkEditor
	def initialize(link_parent_action)
		super()
		self.target=link_parent_action.target

		#@help_label.Text=intl_str("Link parent window")
	end
end

class LinkParentFrameActionEditor < LinkEditor
	def initialize(link_parent_frame_action)
		super()
		self.target=link_parent_frame_action.target
		#@help_label.Text=intl_str("Link parent frame")
	end
end

class LinkPopupActionEditor < LinkEditor
	class PopupPropertiesEditor < AML::Control
		def initialize(link_popup_action)

			#self.auto_size = true
            self.vertical_alignment = LayoutAlignment.Fit
			initialize_component("dialogs/interaction_editor_dlg/popup_properties_editor.aml")

			@link_popup_action = link_popup_action
			@popup_props = @link_popup_action.popup

			@toolbars_check_button.selected = @popup_props.popup_show_toolbar
			@scrollbars_check_button.selected = @popup_props.popup_show_scrollbars
			@location_check_button.selected = @popup_props.popup_show_location
			@status_check_button.selected = @popup_props.popup_show_status

			@menubar_check_button.selected = @popup_props.popup_show_menubar
			@directories_check_button.selected = @popup_props.popup_show_directories
			@resizable_check_button.selected = @popup_props.popup_is_resizable
			@center_screen_check_button.selected = @popup_props.popup_center_window

			@top_number_box.value = @popup_props.popup_top
			@left_number_box.value = @popup_props.popup_left
			@width_number_box.value = @popup_props.popup_width
			@height_number_box.value = @popup_props.popup_height

		end

		def toolbars_selected_changed(sender, event_args)
			@popup_props.popup_show_toolbar = @toolbars_check_button.selected
		end

		def scrollbars_selected_changed(sender, event_args)
			@popup_props.popup_show_scrollbars = @scrollbars_check_button.selected
		end

		def location_selected_changed(sender, event_args)
			@popup_props.popup_show_location = @location_check_button.selected
		end

		def status_selected_changed(sender, event_args)
			@popup_props.popup_show_status = @status_check_button.selected
		end

		def menubar_selected_changed(sender, event_args)
			@popup_props.popup_show_menubar = @menubar_check_button.selected
		end

		def directories_selected_changed(sender, event_args)
			@popup_props.popup_show_directories = @directories_check_button.selected
		end

		def resizable_selected_changed(sender, event_args)
			@popup_props.popup_is_resizable = @resizable_check_button.selected
		end

		def center_screen_selected_changed(sender, event_args)
			@popup_props.popup_center_window = @center_screen_check_button.selected
		end

		def width_number_box_value_changed(sender, event_args)
			@popup_props.popup_width = @width_number_box.value
		end

		def height_number_box_value_changed(sender, event_args)
			@popup_props.popup_height = @height_number_box.value
		end

		def left_number_box_value_changed(sender, event_args)
			@popup_props.popup_left = @left_number_box.value
		end

		def top_number_box_value_changed(sender, event_args)
			@popup_props.popup_top = @top_number_box.value
		end
	end

	def initialize(link_popup_action)
		super()
		self.target=link_popup_action.target
		#@help_label.Text=intl_str("Open Popup")

		@popup_editor = PopupPropertiesEditor.new(link_popup_action)
		@stack_layout_panel.add_control(@popup_editor)
	end
end

class CloseCurrentActionEditor < InteractionPropertiesEditor
end

class LinkFrameActionEditor < LinkEditor
	def initialize(diagram, link_frame_action)
		super()
		#@help_label.Text=intl_str("Link Frame")

        hide_reload_and_back()

		@link_frame_action = link_frame_action
		@widget_treeview = WidgetTreeView.new
		@widget_treeview.has_check_box = true
        @widget_treeview.BackGroundFill= Axure::Platform::Drawing::SolidFill.new(Axure::Platform::Drawing::AxColor.White)

		scroll_panel = ScrollPanel.new
		scroll_panel.content = @widget_treeview
		scroll_panel.desired_height = 150
		scroll_panel.width = 250
		scroll_panel.auto_scroll_size = false
        scroll_panel.SetAttachedProperty(GridLayoutPanel.ROW, 0)

#		container = WindowlessControl.new
#		container.height = 105
#		container.add_control(scroll_panel)
#        container.SetAttachedProperty(GridLayoutPanel.ROW, 0)
		@outer_grid_layout_panel.add_control(scroll_panel)

		@types = [AxureType::DiagramObject.InlineFrame, AxureType::DiagramObject.DynamicPanel]
		@widget_treeview.diagram = diagram
		@widget_treeview.diagram_object_filter = System::Predicate[DiagramObject].new do |dobj| @types.include?(dobj.type_name) end
		@widget_treeview.diagram_object_collection = diagram.diagram_objects
		@widget_treeview.update_tree_view

        @widget_treeview.node_expanded.add(
            lambda { |sender, event_args|
              tn = event_args.control
              for child in tn.depth_first_descendants do
                      child.checked_state = AxCheckButtonState.selected if @link_frame_action.contains_frame_to_target_association(child.diagram_object)
              end
        })

		@widget_treeview.checked_node_changed.add(lambda { |s, e| widget_treeview_checked_node_changed(s,e) })
		@widget_treeview.current_node_changed.add(lambda { |s, e| widget_treeview_current_node_changed(s,e) })

		for f in @link_frame_action.frame_to_target.keys
			tn = @widget_treeview.get_tree_node_by_diagram_object(f)
			if tn
				tn.checked_state = AxCheckButtonState.selected
			end
		end
	end

	def widget_treeview_checked_node_changed(sender, event_args)
		tn = event_args.control
		frame= tn.diagram_object

		if frame.type_name != AxureType::DiagramObject.InlineFrame
			tn.checked_state = AxCheckButtonState.unselected
			return
		end

		if tn.checked_state == AxCheckButtonState.selected
			if !@link_frame_action.frame_to_target.contains_key(frame)
				@link_frame_action.add_frame_to_target(frame)
				self.target=@link_frame_action.frame_to_target[frame]
				@widget_treeview.current_node = tn
			end
		else
			if @link_frame_action.frame_to_target.contains_key(frame)
				@link_frame_action.remove_frame_to_target(frame)
				self.target=nil
			end
		end
	end

	def widget_treeview_current_node_changed(sender, event_args)
		tn = @widget_treeview.current_node
		if tn && tn.checked_state == AxCheckButtonState.selected
			self.target=@link_frame_action.frame_to_target[tn.diagram_object]
		else
			self.target=nil
		end
	end
end


