require 'aml'
require 'axure_enumerable'
require 'Model'
require ('dialogs/interaction_editor_dlg/dynamic_panel_editor')
require ('dialogs/interaction_editor_dlg/link_editor')
require ('dialogs/interaction_editor_dlg/misc_editor')
require ('dialogs/interaction_editor_dlg/widget_editor')
#
#shared with wireframe-> manage raise event
require ('dialogs/raise_event_action_editor')

include Axure::Platform::Controls

include Axure::Client::Interaction
include Axure::Client::WindowlessControls

include Axure::DocumentModel
include Axure::DocumentModel::Interaction

# = supporting files: =
# interaction_editor_dlg.rb - 3 panes dialog
# interaction_properties_editor.rb - base class for the other editors, loads aml file
# widget_editor.rb - also is a base class for dynamic_panel_editor::PanelEditor
# dynamic_panel_editor.rb
# link_editor.rb
# misc_editor.rb - other, wait time, expr action
class InteractionEditorDialog < AML::Control
	def initialize()
		initialize_component('dialogs/interaction_editor_dlg/interaction_editor_dlg.aml')
		#self.size = AxSize.new(550, 300)
	end

	def dialog_info=(_info)
        _info.default_size = AxSizeF.new(805,570)
        _info.min_size = AxSizeF.new(805,510)

		@interaction_map = _info.interaction_map
		@interaction_case = _info.interaction_case

        update_condition_text()

		node = @interaction_map.get_node_from_object(@interaction_case)
		interaction_event = @interaction_map.get_object_from_node( node.parent_node)
		@interaction_event_type = interaction_event.event_type

        @description_textbox.text = @interaction_case.description

		@client = _info.client

		@itv.client=_info.client
		@itv.current_document=_info.client.document
		@itv.current_tree_map = _info.interaction_map
		@itv.current_interaction_case = _info.interaction_case
		@itv.current_interaction_action = _info.interaction_action

        _info.before_close.add(lambda { |s, e| before_close(s,e) })

		@actions_list.for_master = (@interaction_case.owner.type_name == AxureType.Master)
	end

    def before_close(sender, event_args)
      @itv.current_tree_map = nil
    end

	def switch_view_button_clicked(sender, event_args)
		@actions_list.ListMode = !@actions_list.ListMode
		sender.Text = @actions_list.ListMode ? "Category View" : "List View"
	end

	def add_all_button_clicked(sender, event_args)
		actions = [ AxureType::Interaction.WaitAction, AxureType::Interaction.ExprAction, AxureType::Interaction.LinkCurrentAction, AxureType::Interaction.LinkPopupAction, AxureType::Interaction.LinkParentAction, AxureType::Interaction.CloseCurrentAction, AxureType::Interaction.LinkFrameAction, AxureType::Interaction.LinkParentFrameAction, AxureType::Interaction.SetPanelStateAction, AxureType::Interaction.ShowPanelAction, AxureType::Interaction.HidePanelAction, AxureType::Interaction.TogglePanelVisibilityAction, AxureType::Interaction.MoveWidgetAction, AxureType::Interaction.BringPanelToFrontAction, AxureType::Interaction.SendPanelToBackAction, AxureType::Interaction.ScrollToWidgetAction, AxureType::Interaction.EnableWidgetsAction, AxureType::Interaction.DisableWidgetsAction, AxureType::Interaction.SetWidgetsToPropertySetAction, AxureType::Interaction.SetFocusOnWidgetAction, AxureType::Interaction.ExpandWidgetsAction, AxureType::Interaction.CollapseWidgetsAction, AxureType::Interaction.OtherAction ]

		for a in actions
			actionslist_add_interaction_clicked(nil, InteractionActionsList::InteractionTypeEventArgs.new(a))
		end
	end

	def actionslist_add_interaction_clicked(sender, event_args)
		ia = nil

		case event_args.InteractionType
		when AxureType::Interaction.WaitAction
			ia = InteractionWaitAction.new(@interaction_map.owner)
		when AxureType::Interaction.ExprAction
			ia = InteractionExprAction.new(@interaction_map.owner)
		when AxureType::Interaction.LinkCurrentAction
			ia = InteractionLinkCurrentAction.new(@interaction_map.owner)
		when AxureType::Interaction.LinkPopupAction
			ia = InteractionLinkPopupAction.new(@interaction_map.owner)
          when AxureType::Interaction.LinkNewTabAction
            ia = InteractionLinkNewTabAction.new(@interaction_map.owner)
		when AxureType::Interaction.LinkParentAction
			ia = InteractionLinkParentAction.new(@interaction_map.owner)
		when AxureType::Interaction.CloseCurrentAction
			ia = InteractionCloseCurrentAction.new(@interaction_map.owner)
		when AxureType::Interaction.LinkFrameAction
			ia = InteractionLinkFrameAction.new(@interaction_map.owner)
		when AxureType::Interaction.LinkParentFrameAction
			ia = InteractionLinkParentFrameAction.new(@interaction_map.owner)
		when AxureType::Interaction.SetPanelStateAction
			ia = InteractionSetPanelStateAction.new(@interaction_map.owner)
		when AxureType::Interaction.ShowPanelAction
			#ia = InteractionShowPanelAction.new(@interaction_map.owner)
            ia = InteractionFadeWidgetAction.new(@interaction_map.owner)
            ia.FadeActionType = FadeActionType.Show
		when AxureType::Interaction.HidePanelAction
			#ia = InteractionHidePanelAction.new(@interaction_map.owner)
            ia = InteractionFadeWidgetAction.new(@interaction_map.owner)
            ia.FadeActionType = FadeActionType.Hide
		when AxureType::Interaction.TogglePanelVisibilityAction
			#ia = InteractionTogglePanelVisibilityAction.new(@interaction_map.owner)
            ia = InteractionFadeWidgetAction.new(@interaction_map.owner)
            ia.FadeActionType = FadeActionType.Toggle
		when AxureType::Interaction.MoveWidgetAction
			ia = InteractionMoveWidgetAction.new(@interaction_map.owner)
		when AxureType::Interaction.BringPanelToFrontAction
			ia = InteractionBringPanelToFrontAction.new(@interaction_map.owner)
        when AxureType::Interaction.SendPanelToBackAction
            ia = InteractionSendPanelToBackAction.new(@interaction_map.owner)
		when AxureType::Interaction.ScrollToWidgetAction
			ia = InteractionScrollToWidgetAction.new(@interaction_map.owner)
		when AxureType::Interaction.EnableWidgetsAction
			ia = InteractionEnableWidgetsAction.new(@interaction_map.owner)
		when AxureType::Interaction.DisableWidgetsAction
			ia = InteractionDisableWidgetsAction.new(@interaction_map.owner)
		when AxureType::Interaction.SetWidgetsToPropertySetAction
			ia = InteractionSetWidgetsToPropertySetAction.new(@interaction_map.owner)
		when AxureType::Interaction.SetFocusOnWidgetAction
			ia = InteractionSetFocusOnWidgetAction.new(@interaction_map.owner)
		when AxureType::Interaction.ExpandWidgetsAction
			ia = InteractionExpandWidgetsAction.new(@interaction_map.owner)
		when AxureType::Interaction.CollapseWidgetsAction
			ia = InteractionCollapseWidgetsAction.new(@interaction_map.owner)
		when AxureType::Interaction.OtherAction
			ia = InteractionOtherAction.new(@interaction_map.owner)
		when AxureType::Interaction.RaiseEventAction
			ia = InteractionRaiseEventAction.new(@interaction_map.owner)
		end

		sTreeNode = @itv.current_node
		sTreeNode = @itv.children.first if sTreeNode == nil

		interaction_node = @interaction_map.get_node_from_object(@interaction_case)
		insertIndex = sTreeNode.Index + 1
		if sTreeNode.TreeMapNode == interaction_node
			insertIndex = interaction_node.NumberChildren;
		end


		newNode = @interaction_map.AddNode(nil, interaction_node, insertIndex, ia);
		@itv.current_node_id = newNode.UniqueIdentifier
        @itv.focus
	end

	def edit_case_condition_clicked (s, e)

      info = Axure::Client::Dialogs::WindowlessDialogInfo.new
      #info.dialog = ead
      info.title = intl_str("Condition Builder")
      info.default_size = AxSizeF.new(790, 400)
      info.min_size = AxSizeF.new(700, 250)

		ead = ExprActionDialog.new(info)
		ead.client = @client

		#ead.Text =   Axure.International.Local.GetString("Condition Builder");
		#set properties in the same order as W32CaseEditorDialog
		ead.set_condition_mode(@interaction_event_type, @interaction_map)
		ead.diagram = @interaction_case.owner.diagram
		ead.expression = @interaction_case.condition


		if info.show_dialog() == AxDialogResult.OK
			@interaction_case.condition = ead.expression
    end

    update_condition_text()
	end

    def clear_case_condition_clicked (s, e)
		@interaction_case.condition = nil
        update_condition_text()
    end

    def update_condition_text()
        if (@interaction_case.condition != nil)
            @edit_condition_button.text = intl_str("Edit Condition")
            @clear_condition_button.visible = true
        else
            @edit_condition_button.text = intl_str("Add Condition")
            @clear_condition_button.visible = false
        end
    end

    def description_textbox_textchanged(sender, event_args)
      @interaction_case.description = @description_textbox.text
    end

	def itv_current_node_changed(sender, event_args)
		node = @itv.current_tree_map_node
        if (node != nil)
		  @current_action = @interaction_map.get_object_from_node(node)
        else
          @current_action = nil
        end
		if @current_action==nil || !@current_action.is_a?(InteractionAction)
			@action_textbox.text = intl_str("Select an action to edit.")
			#@editor_panel.Content = @action_textbox
            #@action_textbox.SetAttachedProperty(GridLayoutPanel.ROW, 1)
            #@editor_grid.add_control(@action_textbox)
            @editor_grid.Content = @action_text_layout_panel
			return
		end

		@action_textbox.text = @current_action.type_name

		case @current_action.type_name
		when AxureType::Interaction.WaitAction
			new_editor = WaitActionEditor.new(@current_action)
		when AxureType::Interaction.ExprAction
			new_editor = ExprActionEditor.new(@client, @interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.LinkCurrentAction
			new_editor = LinkCurrentActionEditor.new(@current_action)
		when AxureType::Interaction.LinkNewTabAction
			new_editor = LinkNewTabActionEditor.new(@current_action)
		when AxureType::Interaction.LinkPopupAction
			new_editor = LinkPopupActionEditor.new(@current_action)
		when AxureType::Interaction.LinkParentAction
			new_editor = LinkParentActionEditor.new(@current_action)
		when AxureType::Interaction.CloseCurrentAction
			new_editor = CloseCurrentActionEditor.new(@current_action)
		when AxureType::Interaction.LinkFrameAction
			new_editor = LinkFrameActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.LinkParentFrameAction
			new_editor = LinkParentFrameActionEditor.new(@current_action)
		when AxureType::Interaction.SetPanelStateAction
			new_editor = SetPanelStateActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.ShowPanelAction
			new_editor = ShowPanelActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.HidePanelAction
			new_editor = HidePanelActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.TogglePanelVisibilityAction
			new_editor = TogglePanelVisibilityActionEditor.new(@interaction_case.owner.diagram, @current_action)
        when AxureType::Interaction.FadeWidgetAction
            new_editor = FadeWidgetActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.MoveWidgetAction
			new_editor = MoveWidgetActionEditor.new(@interaction_case.owner.diagram, @current_action)
            new_editor.event_type = @interaction_event_type
		when AxureType::Interaction.BringPanelToFrontAction
			new_editor = BringPanelToFrontActionEditor.new(@interaction_case.owner.diagram, @current_action)
        when AxureType::Interaction.SendPanelToBackAction
              new_editor = SendPanelToBackActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.ScrollToWidgetAction
			new_editor = ScrollToWidgetActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.EnableWidgetsAction
			new_editor = EnableWidgetsActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.DisableWidgetsAction
			new_editor = DisableWidgetsActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.SetWidgetsToPropertySetAction
			new_editor = SetWidgetsToPropertySetActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.SetFocusOnWidgetAction
			new_editor = SetFocusOnWidgetActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.ExpandWidgetsAction
			new_editor = ExpandWidgetsActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.CollapseWidgetsAction
			new_editor = CollapseWidgetsActionEditor.new(@interaction_case.owner.diagram, @current_action)
		when AxureType::Interaction.OtherAction
			new_editor = OtherActionEditor.new(@current_action)
		when AxureType::Interaction.RaiseEventAction
			new_editor = RaiseEventActionEditor.new
			new_editor.master = @interaction_case.owner
			new_editor.raise_event_action = @current_action
		end

		#new_editor.size = @editor_panel.size
        #new_editor.SetAttachedProperty(GridLayoutPanel.ROW, 1)
		#@editor_panel.Content = new_editor
      @editor_grid.Content = new_editor
	end

    def itv_tree_edit(sender, event_args)
      if event_args.edit.is_a?(Axure::DocumentModel::Edit::CompositeEdit)
          #compositeEdit = (CompositeEdit)event_args.edit
          #compositeEdit.commit()
          event_args.edit.Commit()
      else
          event_args.edit.Commit()
      end
    end

  def show_step2_clicked(sender, event_args)
    if @step2_grid_layout.visible
      @show_step2_button.text = intl_str("Show Step 2")
      @step2_grid_layout.visible = false
    else
      @show_step2_button.text = intl_str("Hide Step 2")
      @step2_grid_layout.visible = true
    end
  end
end
