require 'aml'
require 'interop'
require 'dialogs/interaction_editor_dlg/interaction_properties_editor'
require 'dialogs/interaction_editor_dlg/widget_editor'
require 'dialogs/interaction_editor_dlg/panel_to_state_check_button'

include System::Collections
include System::Collections::Generic

class PanelEditor < WidgetActionEditor
	def initialize(diagram, widget_action) 
		@filter = [ AxureType::DiagramObject.DynamicPanel]
		@dynamic_panel_selectable = true
		@hide_empty_dynamic_panel = false
		super(diagram, widget_action)
	end

	def diagram_object_filter(diagram_object)
		return @filter.include?(diagram_object.type_name)
	end
end

class TogglePanelVisibilityActionEditor < PanelEditor
	def initialize(diagram, widget_action) 
		super(diagram, widget_action)
		@help_label.text = intl_str("Select the panels to toggle")
	end
end

class ShowPanelActionEditor < PanelEditor
	def initialize(diagram, widget_action) 
		super(diagram, widget_action)
		@help_label.text = intl_str("Select the panels to show")
	end
end

class HidePanelActionEditor < PanelEditor
	def initialize(diagram, widget_action) 
		super(diagram, widget_action)
		@help_label.text = intl_str("Select the panels to hide")
	end
end

class FadeWidgetActionEditor < PanelEditor
	include Axure::Client::Interaction
    class FadeWidgetEditor < AML::Control
      def initialize()
        initialize_component("dialogs/interaction_editor_dlg/fade_widget_editor.aml")

        fade = System::Array[System::String].new(2)
        fade[0] = intl_str("none")
        fade[1] = intl_str("fade")
        @easing_select_list.string_items = fade

      end

      def tree_node=(tree_node)
        @current_tree_node = tree_node
        if !@current_tree_node
          @state_grid.enabled = false
          @easing_select_list.selected_index = -1
          @duration_number_box.text = ""
          return
        end

        @state_grid.enabled = true

        @easing_select_list.selected_index = @current_tree_node.EasingSelectedIndex
        @duration_number_box.text = @current_tree_node.DurationValue

        if (@current_tree_node.EasingSelectedIndex < 1)
            @duration_number_box.enabled = false
        end
      end

      def easing_select_list_item_selected(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetEasingValue(@easing_select_list.selected_index)
          if (@current_tree_node.EasingSelectedIndex < 1)
            @duration_number_box.enabled = false
          else
            @duration_number_box.enabled = true
          end
        end
      end

      def duration_number_box_value_changed(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetDurationValue(@duration_number_box.value)
        end
      end

    end

	def initialize(diagram, widget_action)
		@custom_treenode_generator = lambda {|dobj, parent_node| generate_tree_node(dobj, parent_node)}
		super(diagram, widget_action)

        @widget_treeview.node_expanded.add(
            lambda { |sender, event_args|
                tn = event_args.control
                for child in tn.depth_first_descendants do
                    child.checked_state = AxCheckButtonState.selected if @widget_action.contains_widget_path_to_fade_info_association(child.diagram_object_path)
            end
        })

        dop_to_remove_list = System::Collections::Generic::List[Axure::DocumentModel::DiagramObjectPath].new
		for dpp in @widget_action.widget_paths_to_fade_infos.keys
			tn = @widget_treeview.get_tree_node_by_diagram_object_path(dpp)
			if (tn)
              tn.checked_state = AxCheckButtonState.selected
            else
              dop_to_remove_list.add(dpp)
            end
		end
        for dpp in dop_to_remove_list
            @widget_action.RemoveWidgetPathToFadeInfo(dpp)
        end

		@help_label.text = intl_str("Select the panels to " + @widget_action.GetLowerFadeActionTypeText())

        @fade_widget_editor = FadeWidgetEditor.new()
        @fade_widget_editor.tree_node =nil
        @fade_widget_editor.desired_height = 35
        @stack_layout_panel.add_control(@fade_widget_editor)

        @widget_treeview.checked_node_changed.add(lambda { |s, e| widget_treeview_checked_node_changed(s,e) })
        @widget_treeview.current_node_changed.add(lambda { |s, e| widget_treeview_current_node_changed(s,e) })

	end

	def generate_tree_node(dobj, parent_node)
		tn = FadeWidgetTreeNode.new
		tn.diagram = @widget_treeview.diagram
		tn.diagram_object = dobj
		tn.fade_panel_action = @widget_action
		tn.parent_tree_view = @widget_treeview
		return tn
    end

  	def widget_treeview_checked_node_changed(sender, event_args)
        super(sender, event_args)
		tn = event_args.control

        if (tn != @widget_treeview.current_node)
          return
        end

        if (@fade_widget_editor)
          if tn && tn.checked_state == AxCheckButtonState.selected
              @fade_widget_editor.tree_node = tn
          else
              @fade_widget_editor.tree_node =nil
          end
        end
	end

	def widget_treeview_current_node_changed(sender, event_args)
		tn = @widget_treeview.current_node
		if tn && tn.checked_state == AxCheckButtonState.selected
			@fade_widget_editor.tree_node = tn
		else
			@fade_widget_editor.tree_node = nil
		end
	end
end


class BringPanelToFrontActionEditor < PanelEditor
	def initialize(diagram, widget_action) 
		super(diagram, widget_action)
		@help_label.text = intl_str("Select the panels to bring to front")
	end
end

class SendPanelToBackActionEditor  < PanelEditor
	def initialize(diagram, widget_action)
		super(diagram, widget_action)
		@help_label.text = intl_str("Select the panels to send to back")
	end
end

class MoveWidgetActionEditor < PanelEditor
	include Axure::Client::Interaction
    class MoveWidgetEditor < AML::Control
      def initialize()
        initialize_component("dialogs/interaction_editor_dlg/move_widget_editor.aml")

        @easing_select_list.string_items = InteractionMoveWidgetAction.GetAllEasingFriendlyStrings()

        @tobycount = 2
        toby = System::Array[System::String].new(2)
        toby[0] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.location)
        toby[1] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.delta)
        @by_to_select_list.string_items = toby
      end

      def event_type=(event_type)
        @event_type = event_type
        if (event_type == InteractionEventType.OnDrag || event_type == InteractionEventType.OnDragDrop)
          @tobycount = 6
          toby = System::Array[System::String].new(6)
          toby[0] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.location)
          toby[1] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.delta)
          toby[2] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.drag)
          toby[3] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.dragX)
          toby[4] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.dragY)
          toby[5] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.locationBeforeDrag)
          @by_to_select_list.string_items = toby
          @by_to_select_list.width = 100
        elsif (event_type == InteractionEventType.OnMove)
          @tobycount = 3
          toby = System::Array[System::String].new(3)
          toby[0] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.location)
          toby[1] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.delta)
          toby[2] = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.withThis)
          @by_to_select_list.string_items = toby
          @by_to_select_list.width = 100
        end
      end

      def tree_node=(tree_node)
        @current_tree_node = tree_node
        if !@current_tree_node
          @state_grid.enabled = false
          @x_number_box.text = ""
          @y_number_box.text = ""
          @by_to_select_list.selected_index = -1
          @easing_select_list.selected_index = -1
          @duration_number_box.text = ""
          return
        end
        
        @state_grid.enabled = true

        @x_number_box.text = @current_tree_node.XValue
        @y_number_box.text = @current_tree_node.YValue
        if (!@by_to_select_list.contains_string(@current_tree_node.ToBySelectedName))
          @by_to_select_list.string_value = InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.delta)
        else
          @by_to_select_list.string_value = @current_tree_node.ToBySelectedName
        end
        @easing_select_list.selected_index = @current_tree_node.EasingSelectedIndex
        @duration_number_box.text = @current_tree_node.DurationValue

        set_enabled_for_by_to()
      end

      def x_number_box_value_changed(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetXValue(@x_number_box.value)
        end
      end

      def y_number_box_value_changed(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetYValue(@y_number_box.value)
        end
      end

      def by_to_select_list_item_selected(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetByToValue(@by_to_select_list.string_value)
          set_enabled_for_by_to()
        end
      end

      def set_enabled_for_by_to()
          if (@by_to_select_list.selected_index > 1)
            @x_number_box.enabled = false;
            @y_number_box.enabled = false;
          else
            @x_number_box.enabled = true;
            @y_number_box.enabled = true;
          end

          if (@current_tree_node.ToBySelectedName == InteractionMoveWidgetAction.GetMoveTypeFriendlyString(MoveWidgetType.withThis))
            @easing_select_list.selected_index = 0
            @easing_select_list.enabled = false
            @duration_number_box.enabled = false
          else
            @easing_select_list.enabled = true
            @duration_number_box.enabled = true
          end

          set_enabled_for_easing()        
      end

      def easing_select_list_item_selected(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetEasingValue(@easing_select_list.selected_index)
          set_enabled_for_easing()
        end
      end

      def set_enabled_for_easing()
        if (@current_tree_node.EasingSelectedIndex < 1)
            @duration_number_box.enabled = false
          else
            @duration_number_box.enabled = true
          end
      end

      def duration_number_box_value_changed(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetDurationValue(@duration_number_box.value)
        end
      end

    end

	def initialize(diagram, widget_action) 
		@custom_treenode_generator = lambda {|dobj, parent_node| generate_tree_node(dobj, parent_node)} 
		super(diagram, widget_action)

        @widget_treeview.node_expanded.add(
            lambda { |sender, event_args|
                tn = event_args.control
                for child in tn.depth_first_descendants do
                    child.checked_state = AxCheckButtonState.selected if @widget_action.contains_widget_path_to_move_info_association(child.diagram_object_path)
            end
        })

        dop_to_remove_list = System::Collections::Generic::List[Axure::DocumentModel::DiagramObjectPath].new
		for dpp in @widget_action.widget_paths_to_move_infos.keys
			tn = @widget_treeview.get_tree_node_by_diagram_object_path(dpp)
			if (tn)
              tn.checked_state = AxCheckButtonState.selected
            else
              dop_to_remove_list.add(dpp)
            end
		end
        for dpp in dop_to_remove_list
            @widget_action.RemoveWidgetPathToMoveInfo(dpp)
        end

		@help_label.text = intl_str("Select the panels to move")

        @move_widget_editor = MoveWidgetEditor.new()
        @move_widget_editor.tree_node =nil
        @move_widget_editor.desired_height = 65
        @stack_layout_panel.add_control(@move_widget_editor)

        @widget_treeview.checked_node_changed.add(lambda { |s, e| widget_treeview_checked_node_changed(s,e) })
        @widget_treeview.current_node_changed.add(lambda { |s, e| widget_treeview_current_node_changed(s,e) })

	end

    def event_type=(event_type)
      @event_type = event_type
      @move_widget_editor.event_type = event_type
    end

	def generate_tree_node(dobj, parent_node)
		tn = MoveDynamicPanelTreeNode.new
		tn.diagram = @widget_treeview.diagram
		tn.diagram_object = dobj
		tn.move_panel_action = @widget_action
		tn.parent_tree_view = @widget_treeview
		return tn
    end

  	def widget_treeview_checked_node_changed(sender, event_args)
        super(sender, event_args)
		tn = event_args.control

        if (tn != @widget_treeview.current_node)
          return
        end

        if (@move_widget_editor)
          if tn && tn.checked_state == AxCheckButtonState.selected
            if @event_type == InteractionEventType.OnDrag
              tn.SetByToValue(MoveWidgetType.drag)
            elsif @event_type == InteractionEventType.OnDragDrop
              tn.SetByToValue(MoveWidgetType.locationBeforeDrag)
            elsif @event_type == InteractionEventType.OnMove
              tn.SetByToValue(MoveWidgetType.withThis)
            end
            @move_widget_editor.tree_node = tn
          else
              @move_widget_editor.tree_node =nil
          end
        end
	end

	def widget_treeview_current_node_changed(sender, event_args)
		tn = @widget_treeview.current_node
		if tn && tn.checked_state == AxCheckButtonState.selected
			@move_widget_editor.tree_node = tn
		else
			@move_widget_editor.tree_node = nil
		end
	end
end

class SetPanelStateActionEditor < PanelEditor
	include Axure::Client::Interaction
    class SetPanelStateEditor < AML::Control
      def initialize()
        initialize_component("dialogs/interaction_editor_dlg/set_panel_state_editor.aml")
        
        @enter_easing_select_list.string_items = InteractionSetPanelStateAction.GetAllEasingFriendlyStrings()
        @exit_easing_select_list.string_items = InteractionSetPanelStateAction.GetAllEasingFriendlyStrings()
      end

      def tree_node=(tree_node)
        @current_tree_node = tree_node
        if !@current_tree_node
          @state_grid.enabled = false
          @animate_grid.enabled = false
          @enter_easing_select_list.selected_index = -1
          @enter_duration_number_box.text = ""
          @exit_easing_select_list.selected_index = -1
          @exit_duration_number_box.text = ""
          return
        end

        @state_grid.enabled = true
        @animate_grid.enabled = true

        @state_select_list.string_items = @current_tree_node.state_strings
        @state_select_list.selected_index = @current_tree_node.current_state_index
        @enter_easing_select_list.selected_index = @current_tree_node.EnterEasingSelectedIndex
        @enter_duration_number_box.text = @current_tree_node.EnterDurationValue
        if (@current_tree_node.EnterEasingSelectedIndex < 1)
            @enter_duration_number_box.enabled = false
        end
        @exit_easing_select_list.selected_index = @current_tree_node.ExitEasingSelectedIndex
        @exit_duration_number_box.text = @current_tree_node.ExitDurationValue
        if (@current_tree_node.ExitEasingSelectedIndex < 1)
            @exit_duration_number_box.enabled = false
        end
        
      end

      def state_select_list_item_selected(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetCurrentState(@state_select_list.selected_index)
        end
      end

      def enter_easing_select_list_item_selected(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetEnterEasingValue(@enter_easing_select_list.selected_index)
          if (@current_tree_node.EnterEasingSelectedIndex < 1)
            @enter_duration_number_box.enabled = false
          else
            @enter_duration_number_box.enabled = true
          end
        end
      end

      def enter_duration_number_box_value_changed(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetEnterDurationValue(@enter_duration_number_box.value)
        end
      end

      def exit_easing_select_list_item_selected(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetExitEasingValue(@exit_easing_select_list.selected_index)
          if (@current_tree_node.ExitEasingSelectedIndex < 1)
            @exit_duration_number_box.enabled = false
          else
            @exit_duration_number_box.enabled = true
          end
        end
      end

      def exit_duration_number_box_value_changed(sender, event_args)
        if (@current_tree_node)
          @current_tree_node.SetExitDurationValue(@exit_duration_number_box.value)
        end
      end

    end

	def initialize(diagram, widget_action) 
      @custom_treenode_generator = lambda {|dobj, parent_node| generate_tree_node(dobj, parent_node)}
      super(diagram, widget_action)

      @widget_treeview.node_expanded.add(
          lambda { |sender, event_args|
              tn = event_args.control
              for child in tn.depth_first_descendants do
                  child.checked_state = AxCheckButtonState.selected if @widget_action.contains_panel_path_to_diagram_association(child.diagram_object_path)
          end
      })

      dop_to_remove_list = System::Collections::Generic::List[Axure::DocumentModel::DiagramObjectPath].new      
      for dpp in @widget_action.panel_path_to_set_state_info.keys
          tn = @widget_treeview.get_tree_node_by_diagram_object_path(dpp)
          if (tn)
            tn.checked_state = AxCheckButtonState.selected
          else
            dop_to_remove_list.add(dpp)
          end
      end
      for dpp in dop_to_remove_list
          @widget_action.RemovePanelPathToDiagram(dpp)
      end

      @widget_treeview.checked_node_changed.add(lambda { |s, e| widget_treeview_checked_node_changed(s,e) })
      @widget_treeview.current_node_changed.add(lambda { |s, e| widget_treeview_current_node_changed(s,e) })

      @help_label.text = intl_str("Select the panels to set the state")

      @set_panel_state_editor = SetPanelStateEditor.new()
      @set_panel_state_editor.tree_node =nil
      @set_panel_state_editor.desired_height = 105
      @stack_layout_panel.add_control(@set_panel_state_editor)    
    end

	def generate_tree_node(dobj, parent_node)
		tn = SetPanelToStateTreeNode.new
		tn.diagram = @widget_treeview.diagram
		tn.diagram_object = dobj
		tn.set_panel_state_action = @widget_action
		tn.parent_tree_view = @widget_treeview
		return tn
    end

  	def widget_treeview_checked_node_changed(sender, event_args)
        super(sender, event_args)
		tn = event_args.control
        if (tn != @widget_treeview.current_node)
          return          
        end

        if (@set_panel_state_editor)
          if tn && tn.checked_state == AxCheckButtonState.selected
              @set_panel_state_editor.tree_node = tn
          else
              @set_panel_state_editor.tree_node =nil
          end
        end
	end

	def widget_treeview_current_node_changed(sender, event_args)
		tn = @widget_treeview.current_node
		if tn && tn.checked_state == AxCheckButtonState.selected
			@set_panel_state_editor.tree_node = tn
		else
			@set_panel_state_editor.tree_node =nil
		end
	end
end
