
require 'aml'

include Axure::Platform::WindowlessControls
include Axure::Platform::Drawing
include Axure::Client::WindowlessControls
include Axure::Platform
include Axure::Client::Import

class ImportWizard < AML::Control
  attr_reader :import_manager
  bindable_attr_writer :import_manager

  def import_manager=(value)
    @import_manager = value
    my_init()
  end

  def dialog_info=(value)
    @dialog_info = value
    @dialog_info.default_size = AxSizeF.new(530,400)
    @dialog_info.min_size = AxSizeF.new(530,400)
    @dialog_info.default_button = nil

    command_key_pressed.add(lambda { |sender, e| do_command_key_press(sender, e) })
    self.import_manager = value["importManager"]
  end

  def initialize()
    initialize_component('dialogs/import/import_wizard.aml')
  end

  def my_init()
    load_current_step()
    set_allow_next_prev()

    import_manager.current_step_changed.add(lambda { load_current_step })
    import_manager.next_step_changed.add(lambda { set_allow_next_prev })
    import_manager.finished.add(lambda { @dialog_info.click_ok } )

#    @dialog_info.before_close.add(lambda { |sender, e|
#      if @dialog_info.dialog_result == AxDialogResult.cancel
#        next_button_clicked
#        e.handled = true
#      end
#    })
  end

  def load_current_step
    @grid_layout.remove_control(@current_page)

    @current_page = import_manager.get_control_for_current_step
    @current_page.set_attached_property(GridLayoutPanel.ROW, 1)

    @grid_layout.add_control(@current_page)

    @skip_to_end_button.visible = import_manager.allow_skip_to_summary

    @title.text = @current_page.title
    @description.text = @current_page.description
  end

  def set_allow_next_prev
    @next_button.enabled = import_manager.can_go_to_next_step
    @previous_button.enabled = import_manager.can_go_to_previous_step

    @next_button.text = intl_str(import_manager.next_step == ImportSteps.finish ? "Finish" : "Next")
  end

  def next_button_clicked
    @current_page.save_state
    import_manager.go_to_next_step
  end

  def previous_button_clicked
    @current_page.save_state
    import_manager.go_to_previous_step
  end

  def cancel_button_clicked
    @dialog_info.click_cancel
  end

  def skip_to_end_button_clicked
    @current_page.save_state
    import_manager.go_to_summary_step
  end

  def do_command_key_press(sender, e)
    if(e.key_data == AxKeys.enter)
      next_button_clicked
      e.handled = true
    end
  end
end