require 'aml'

class WordTemplatePane < AML::Control
  attr_reader :configuration, :options, :word_options
  bindable_attr_writer :configuration, :options, :word_options

  def my_init()
    self.options = configuration.word2007_spec_options.generator_options
    self.word_options = configuration.word2007_spec_options.word_options
  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/word_template_pane.aml')
  end

  def edit_link_clicked(sender, e)
    begin AxPlatform.PlatformServices.show_url_in_default_browser(configuration.word2007_spec_options.input_docx_file_path)
    rescue StandardError, System::Exception 
			AxPlatform.platform_services.show_message_box(intl_str("The Input File could not be opened. Please try again."))
    end
  end

  def import_link_clicked(sender, e)
    if(is_input_file_closed)
      open_dialog = Axure::Platform::CommonDialogs::AxOpenFileDialogInfo.new
      open_dialog.filter = intl_str("Word Documents (*.docx)|*.docx")

      if (open_dialog.show_dialog == AxDialogResult.o_k && show_new_template_warning)
        System::IO::File.copy(open_dialog.file_name, configuration.word2007_spec_options.input_docx_file_path, true)      
      end
    else show_please_close
    end
  end

  def template_link_clicked(sender, e)
    if(is_input_file_closed)
      template_dialog = Axure::Client::Dialogs::RubyDialogInfo.new
      template_dialog.script_name = "dialogs/generators/spec_gen_dlg/template_builder.rb"
      template_dialog.class_name = "TemplateBuilder"
      if (template_dialog.show_dialog == AxDialogResult.o_k && show_new_template_warning)

        new_template_file = AxPlatform.application_files.startup_path + SEP + intl_str("WordTemplates") + SEP +
                template_dialog[:selected_file]

        if (System::IO::File.Exists(new_template_file))
          System::IO::File.copy(new_template_file, configuration.word2007_spec_options.input_docx_file_path, true)
        end

        self.options.two_column_layout = template_dialog[:is_two_column]

      end

    else show_please_close
    end
  end

  def show_new_template_warning
    AxPlatform.platform_services.show_message_box(intl_str("When a new template is created, the current template is replaced and any changes to it will be lost.\n Are you sure you want to continue?"),
        intl_str("Warning"), AxMessageBoxButtons.YesNo) == AxDialogResult.yes
  end

  def show_please_close
    AxPlatform.platform_services.show_message_box(intl_str("Please close the current Input File before importing."))
  end

  def is_input_file_closed()
    AxPlatform.platform_services.is_file_closed(configuration.word2007_spec_options.input_docx_file_path)
  end

  def word_styles_clicked(sender, e)
    @heading1.text = intl_str("Heading 1")
    @heading2.text = intl_str("Heading 2")
    @heading3.text = intl_str("Heading 3")
    @heading4.text = intl_str("Heading 4")
    @heading_basic.text = intl_str("Heading 5")
    @normal.text = intl_str("Normal")
  end

  def axure_styles_clicked(sender, e)
    @heading1.text = intl_str("AxureHeading1")
    @heading2.text = intl_str("AxureHeading2")
    @heading3.text = intl_str("AxureHeading3")
    @heading4.text = intl_str("AxureHeading4")
    @heading_basic.text = intl_str("AxureHeadingBasic")
    @table.text = intl_str("AxureTableStyle")
    @table_column_header.text = intl_str("AxureTableHeaderText")
    @table_cell_text.text = intl_str("AxureTableNormalText")
    @normal.text = intl_str("Normal")
  end
end
