require 'aml'

include Axure::Client::WindowlessControls

class TemplateSelector < AML::Control
  attr_accessor :dialog_info

  class TemplateDataSource < ListViewDataSource
    include AML, System, Axure::Platform::Storage::IImageStorage

    attr_accessor :id_hash

    def initialize()
      @list = System::Collections::Generic::List[ListViewItem].new
      @image_list = ImageListContainer.word2007_template_image_list

      @id_hash = {
        Guid.new_guid => {
          :image_index => 0,
          :caption => intl_str("Portrait, Simple Style, Letter Size"),
          :doc_name => "PortraitSimpleLetter.docx"
        },
        Guid.new_guid => {
          :image_index => 1,
          :caption => intl_str("Landscape, Two Column, Simple Style, Letter Size"),
          :doc_name => "LandscapeTwoColumnSimpleLetter.docx"
        },
        Guid.new_guid => {
          :image_index => 2,
          :caption => intl_str("Portrait, Styled, Letter Size"),
          :doc_name => "PortraitStyledLetter.docx"
        },
        Guid.new_guid => {
          :image_index => 2,
          :caption => intl_str("Portrait, Styled, A4 Size"),
          :doc_name => "PortraitStyledA4.docx"
        },
        Guid.new_guid => {
          :image_index => 3,
          :caption => intl_str("Portrait, Two Column, Styled, Letter Size"),
          :doc_name => "PortraitTwoColumnStyledLetter.docx"
        },
        Guid.new_guid => {
          :image_index => 4,
          :caption => intl_str("Landscape, Two Column, Styled, Letter Size"),
          :doc_name => "LandscapeTwoColumnStyledLetter.docx"
        },
        Guid.new_guid => {
          :image_index => 4,
          :caption => intl_str("Landscape, Two Column, Styled, Ledger Size"),
          :doc_name => "LandscapeTwoColumnStyledLedger.docx"
        },
        Guid.new_guid => {
          :image_index => 4,
          :caption => intl_str("Landscape, Two Column, Styled, A4 Size"),
          :doc_name => "LandscapeTwoColumnStyledA4.docx"
        },
        Guid.new_guid => {
          :image_index => 5,
          :caption => intl_str("Landscape, Two Column, Styled, Legal Size"),
          :doc_name => "LandscapeTwoColumnStyledLegal.docx"
        },
      }

      @id_hash.each do |key,value|
        lvi = ListViewItem.new
        lvi.text = value[:caption]
        lvi.icon_id = key
        lvi.image_storage = self
        @list.add(lvi)
      end
    end

    def count()
      @list.count
    end

    def updating()
      false
    end

    def get_total_rows(col)
      count / col + (count % col > 0 ? 1 : 0)
    end

    def get_total_columns(row)
      count / row
    end

    def get_list_view_item(index)
      @list[index]
    end

    def get_image(id)
      @image_list.images[@id_hash[id][:image_index]]
    end
  end

  def dialog_info=(info)
    @dialog_info = info

    dialog_info.set_property("selected_file", "PortraitSimpleLetter.docx")
    dialog_info.set_property("is_two_column", false)

    dialog_info.before_close.add(lambda {
      if (@template_list_view.selected_item != nil)
          selected_doc_name = @template_list_view.data_source.id_hash[@template_list_view.selected_item.icon_id][:doc_name]
      else
          selected_doc_name = "PortraitSimpleLetter.docx"
      end

      dialog_info.set_property("selected_file", selected_doc_name)
      dialog_info.set_property("is_two_column", selected_doc_name.include?("TwoColumn"))
    })
  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/template_selector.aml')
    @template_list_view.data_source = TemplateDataSource.new
  end

#  def is_two_column
##    if @template_list_view.selected_items.Count > 0)
##      @template_list_view.data_source.hash[template_list_view.selected_item.icon_id]
##    else
##      "PortraitSimpleLetter.docx"
#    p @template_list_view.data_source.test
#    true
#  end
#
#  def selected_filename
#    return "ProtraitSimpleLetter.docx"
#  end
end