require 'aml'

include Axure::Client::WindowlessControls

class TemplateBuilder < AML::Control
  attr_accessor :dialog_info

  def dialog_info=(info)
    @dialog_info = info
    info.default_size = AxSizeF.new(360,350)
    info.min_size = AxSizeF.new(360,350)
    info.title = intl_str("Create New Template")
    info.o_k_button_text = intl_str("Create")
    
    dialog_info.set_property("selected_file", "PortraitSimpleLetter.docx")
    dialog_info.set_property("is_two_column", false)

    dialog_info.before_close.add(lambda {
      selected_doc_name = @paper_size.StringValue
      selected_doc_name += @portrait.selected ? "Portrait" : "Landscape"
      selected_doc_name += @numbered.selected ? "Numbered" : "NotNumbered"
      selected_doc_name += ".docx"
      p selected_doc_name

      dialog_info.set_property("selected_file", selected_doc_name)
      dialog_info.set_property("is_two_column", @two_column.selected)
    })
  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/template_builder.aml')
  end

end