require 'aml'

include Axure::Platform::WindowlessControls

class ScreenshotPane < AML::Control
  attr_reader :configuration, :options, :include_screenshot_button, :include_screenshot_section_header, :show_footnotes_button
  bindable_attr_writer :configuration, :options

  def my_init()
    self.options = configuration.word2007_spec_options.generator_options

    @width_percent.text = (self.options.max_image_width_percent * 100).round.to_int().to_s()
    @height_percent.text = (self.options.max_image_height_percent * 100).round.to_int().to_s()

  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/screenshot_pane.aml')
  end

  def width_percent_text_changed(sender, e)
    self.options.max_image_width_percent =  @width_percent.value / 100
  end

  def height_percent_text_changed(sender, e)
    self.options.max_image_height_percent =  @height_percent.value / 100
  end


end