require 'aml'

include Axure::Client::WindowlessControls

class NotesPane < AML::Control
  attr_reader :configuration, :options, :include_notes_button, :include_master_usage_button, :include_master_usage_header,
              :include_master_usage_pages_header, :include_master_usage_masters_header, :show_notes_names_headers,
              :include_master_list_button, :include_used_masters_header, :include_page_interactions, :include_page_interactions_header
  bindable_attr_writer :configuration, :options

  def my_init()
    self.options = configuration.word2007_spec_options.generator_options
  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/notes_pane.aml')
  end

  def up_clicked(sender, e)
    @notes_list.move_up()
  end

  def down_clicked(sender, e)
    @notes_list.move_down()
  end
end
