require 'aml'

include Axure::Client::ToolBoxes::Components
include Axure::Client::ToolBoxes::Components::PagesAndMasters

class MastersPane < AML::Control
  attr_reader :configuration, :options, :include_section_button, :include_master_list_button, :include_masters_section_header, :include_master_list_header,
              :collapse_masters_check_button
  bindable_attr_writer :configuration, :options

  def my_init()
    self.options = configuration.word2007_spec_options.generator_options
  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/masters_pane.aml')
  end

  def generate_all_selected_changed
    if @generate_all_button.selected: @tree_grid.enabled = false
    else @tree_grid.enabled = true
    end
  end

  def check_all_clicked
    @master_tree.check_all
  end

  def uncheck_all_clicked
    @master_tree.uncheck_all
  end

  def check_all_children_clicked
    node = @master_tree.current_node
    if (node != nil)
      @master_tree.check_children(node)
    end
  end

  def uncheck_all_children_clicked
    node = @master_tree.current_node
    if (node != nil)
      @master_tree.uncheck_children(node)
    end
  end

  def tree_checked_node_changed
    save_tree()
  end

  def tree_current_node_changed
    #node = @master_tree.current_node
  end

  def save_tree
    options.master_ids_to_generate = @master_tree.checked_ids
  end
end