require 'aml'

include Axure::Client::WindowlessControls

class LayoutPane < AML::Control
  attr_reader :configuration, :options, :include_notes_button, :include_master_usage_button
  bindable_attr_writer :configuration, :options

  def my_init()
    self.options = configuration.word2007_spec_options.generator_options
  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/layout_pane.aml')
  end

  def after_shown()
    if self.options.two_column_layout
      @two_column.selected = true
      @left_percent.text = (self.options.left_column_width_percent * 100).round.to_int().to_s()
    else
      @single_column.selected = true
      @left_percent_panel.enabled = false
    end
    
    @content_list.spec_options = self.options    
  end

  def left_percent_text_changed(sender, e)
    self.options.left_column_width_percent =  @left_percent.value / 100
  end

  def column_selected_changed(sender, e)
    self.options.two_column_layout = @two_column.selected

    if self.options.two_column_layout
      @left_percent_panel.enabled = true
      @left_percent.text = (self.options.left_column_width_percent * 100).round.to_int().to_s()
    else
      @left_percent_panel.enabled = false
    end

    @content_list.spec_options = self.options
  end

  def up_clicked(sender, e)
    @content_list.move_up()
  end

  def down_clicked(sender, e)
    @content_list.move_down()
  end
end
