require 'aml'

class GeneralPane < AML::Control
  attr_reader :configuration
  bindable_attr_writer :configuration

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/general_pane.aml')
  end

  def my_init()
    if (configuration.word2007_spec_options.output_docx_file_path.length == 0)
      @file_text_box.text = AxPlatform.PlatformServices.GetDefaultSpecificationPath() + SEP + configuration.temp_project_name + ".docx"
    end
  end
  
  def file_browse_button_clicked(sender, args)
    save_dialog = Axure::Platform::CommonDialogs::AxSaveFileDialogInfo.new
    save_dialog.filter = intl_str("Word Documents (*.docx)|*.docx")
#    save_dialog.initial_directory = ""

    @file_text_box.text = save_dialog.file_name if save_dialog.show_dialog == AxDialogResult.o_k
  end

  def reset_folder_button_clicked
    reset_folder
  end

  def reset_folder
    @file_text_box.text = AxPlatform.PlatformServices.GetDefaultSpecificationPath() + SEP + configuration.temp_project_name + ".docx"
   end
end