require 'aml'
require 'Model'

include Axure::Client::Generators
include Axure::DocumentModel::SpecGen
include System::Collections::Generic
#include Axure::Linq

class AnnotationsPane < AML::Control
  attr_reader :configuration, :options, :word_options, :include_section_button
  bindable_attr_writer :configuration, :options, :word_options

  def my_init()
    self.options = configuration.word2007_spec_options.generator_options
    self.word_options = configuration.word2007_spec_options.word_options

    @ann_table_list = List[AnnotationTable].new()

    #@body.margins = Borders.new(PlatformTheme.current.header_control_default_indent,0,0,0)
    options.annotation_tables.each do |table_def|
      add_ann_table(table_def)
    end
    set_table_buttons_enabled()
    load_ann_table_select_list()
    @ann_table_select_list.selected_index = 0
  end

  def load_ann_table_select_list
    @ann_table_select_list.string_items = options.annotation_table_names
  end

  def ann_table_select_list_item_selected(sender, e)
    show_ann_table(@ann_table_select_list.selected_index)
  end

  def show_ann_table(index)
    if (@ann_table_stack.controls.count > 0)
      @ann_table_stack.remove_control(@ann_table_stack.controls[0])
    end
    @ann_table_stack.add_control(@ann_table_list[index])
  end

  def add_ann_table(table_def)
    ann_table = AnnotationTable.new(table_def)
    @ann_table_list.add(ann_table)
  end

  def initialize()
    initialize_component('dialogs/generators/spec_gen_dlg/annotations_pane.aml')
  end

  def new_table_button_clicked
    ann_defs_list = List[AnnotationTableDefinition].new(options.annotation_tables)
    new_table_def = AnnotationTableDefinition.new(options.owner)
    ann_defs_list.add(new_table_def)
    options.annotation_tables = ann_defs_list

    add_ann_table(new_table_def)

    set_table_buttons_enabled()
    load_ann_table_select_list()
    @ann_table_select_list.selected_index = ann_defs_list.count - 1
  end

  def remove_button_clicked(sender, e)
    index = @ann_table_select_list.selected_index
    ann_defs_list = List[AnnotationTableDefinition].new(options.annotation_tables)
    ann_def = ann_defs_list[index]
    ann_defs_list.remove(ann_def)
    options.annotation_tables = ann_defs_list

    @ann_table_list.remove_at(index)

    set_table_buttons_enabled()
    load_ann_table_select_list()
    if (index > 0)
      @ann_table_select_list.selected_index = index - 1
    else
      @ann_table_select_list.selected_index = 0
    end
  end

  def show_column_headings_button_clicked(sender, e)
    @column_headings_grid.visible = !@column_headings_grid.visible
    if (@column_headings_grid.visible)
      @show_hide_headings_button.text = intl_str('hide')
    else
      @show_hide_headings_button.text = intl_str('show')
    end
  end

  def set_table_buttons_enabled()
    @remove_button.enabled = @ann_table_list.count() > 1
  end
end