require 'aml'

include Axure::Client::ToolBoxes::Components
include Axure::Client::ToolBoxes::Components::PagesAndMasters

class PrototypePagesPane < AML::Control
  attr_reader :configuration
  bindable_attr_writer :configuration

  def initialize()
    initialize_component('dialogs/generators/html_prototype_dlg/pages_pane.aml')
  end

  def my_init()
  end

  def generate_all_selected_changed
    if @generate_all_button.selected: @tree_grid.enabled = false
    else @tree_grid.enabled = true
    end
  end

  def check_all_clicked
    @page_tree.check_all
  end

  def uncheck_all_clicked
    @page_tree.uncheck_all
  end

  def check_all_children_clicked
    node = @page_tree.current_node
    if (node != nil)
      @page_tree.check_children(node)
    end
  end

  def uncheck_all_children_clicked
    node = @page_tree.current_node
    if (node != nil)
      @page_tree.uncheck_children(node)
    end
  end

  def any_parent_node_unchecked(node)
    if (node.parent_tree_node == node.parent_tree_view || node.parent_tree_node == nil)
      return false
    end
    current = node.parent_tree_node
    if (!current.checked)
      return true
    end
    return any_parent_node_unchecked(current)
  end

  def tree_checked_node_changed
    node = @page_tree.current_node
    if (node != nil && !node.checked)
      @page_tree.uncheck_children(node)
    elsif (node != nil)
      if (any_parent_node_unchecked(node))
        node.checked = false
      end
    end
    save_tree()
  end

  def tree_current_node_changed
    #node = @page_tree.current_node
  end

  def save_tree
    configuration.page_ids_to_generate = @page_tree.checked_ids
  end
end