require 'aml'
require 'Model'

include Axure::DocumentModel::Generators

class PrototypeInteractionsPane < AML::Control
  attr_reader :configuration
  bindable_attr_writer :configuration

  def initialize()
    initialize_component('dialogs/generators/html_prototype_dlg/interactions_pane.aml')
  end

  def my_init()
    case configuration.link_style
      when PrototypeLinkStyle.always_display_targets: @always.selected = true
      when PrototypeLinkStyle.display_multiple_targets_only: @multiple.selected = true
      when PrototypeLinkStyle.never_display_targets: @never.selected = true
    end
  end

  def radio_group_selected_control_changed(sender, e)
    configuration.link_style = case e.control
      when @always: PrototypeLinkStyle.always_display_targets
      when @multiple: PrototypeLinkStyle.display_multiple_targets_only
      when @never: PrototypeLinkStyle.never_display_targets
    end
  end
end