
require 'aml'
require 'dialogs/generators/html_prototype_dlg/general_pane'
require 'dialogs/generators/html_prototype_dlg/pages_pane'
require 'dialogs/generators/html_prototype_dlg/notes_pane'
require 'dialogs/generators/html_prototype_dlg/annotations_pane'
require 'dialogs/generators/html_prototype_dlg/interactions_pane'
require 'dialogs/generators/html_prototype_dlg/distribution_pane'
require 'dialogs/generators/html_prototype_dlg/skinning_pane'
require 'dialogs/generators/html_prototype_dlg/mobile_pane'
require 'dialogs/generators/html_prototype_dlg/advanced_pane'
require 'dialogs/generators/html_prototype_dlg/discuss_pane'

require 'dialogs/package_edit_control'

include Axure::Platform
include Axure::Platform::WindowlessControls

class HtmlPrototypeDialog < PackageEditControl
  attr_reader :configuration, :use_mine_ckbutton
  bindable_attr_writer :configuration; :use_mine_ckbutton

  def configuration=(value)
    raise "configuration is nil" if value == nil

    @configuration = value

  if (@configuration.temp_override_destination_folder.length == 0)
      @configuration.temp_override_destination_folder = AxPlatform.PlatformServices.GetDefaultPrototypePath() + SEP + @configuration.temp_project_name
  end

    panes.each do |x|
      x.configuration = value
      x.my_init() if x.respond_to?(:my_init)
    end

    @package_object = @configuration
    @dialog_info["configuration"] = @configuration

    update_binding(:configuration)
  end

  def dialog_info=(value)
    @dialog_info = value
    self.configuration = value["configuration"]
    @dialog_info.before_shown.add(lambda { @list.focus })

    @dialog_info.before_close.add lambda {|s, e|
      SaveContent()

      if @dialog_info.dialog_result == AxDialogResult.OK
        destinationFolder = @configuration.DestinationFolder

        if @configuration.TempOverrideDestination && self.disable_package_edit
          destinationFolder = @configuration.TempOverrideDestinationFolder
        end

                #remove trailings '\' , and '/'
                destinationFolder = destinationFolder.strip.sub(/[\\\/]*$/, '');

        if !(@configuration.TempOverrideDestination && self.disable_package_edit )
          @configuration.DestinationFolder = destinationFolder
        else
          @configuration.TempOverrideDestinationFolder = destinationFolder
        end

        if (destinationFolder.length == 0)
          AxPlatform.ShowMessageBox(intl_str("The destination folder is not valid.\nPlease select another folder."))
          e.handled = true
          return
        end


        if !System::IO::Directory.Exists(destinationFolder)
          if AxPlatform.ShowMessageBox(
            intl_str("The destination folder does not exist.\nWould you like to create it?"),
            intl_str("Alert"), AxMessageBoxButtons.YesNo) == AxDialogResult.Yes

            begin
              System::IO::Directory.CreateDirectory(destinationFolder);
            rescue StandardError, System::Exception
              AxPlatform.ShowMessageBox(intl_str("The destination folder could not be created.\nPlease select another folder."))
              e.handled = true
            end
          else
            e.handled = true
          end
        end

        @configuration.TempGenerateUsingOverrideDestination = @configuration.TempOverrideDestination && self.disable_package_edit
      end
    }

    value.default_size = AxSizeF.new(550,465)
    value.min_size = AxSizeF.new(550,465)
  end


  def initialize()

    initialize_component('dialogs/generators/html_prototype_dlg/html_prototype_dlg.aml')

    preferred = InterfaceSettings.PreferredBrowser
    installedBrowsers = AxPlatform.PlatformServices.GetInstalledBrowsers()
    if (!installedBrowsers.ContainsKey(Browser.InternetExplorer))
      @internet_explorer.visible = false
    elsif (preferred == Browser.InternetExplorer)
      @internet_explorer.selected = true
    end
    if (!installedBrowsers.ContainsKey(Browser.Firefox))
      @firefox.visible = false
    elsif (preferred == Browser.Firefox)
      @firefox.selected = true
    end
    if (!installedBrowsers.ContainsKey(Browser.Safari))
      @safari.visible = false
    elsif (preferred == Browser.Safari)
      @safari.selected = true
    end
    if (!installedBrowsers.ContainsKey(Browser.Chrome))
      @chrome.visible = false
    elsif (preferred == Browser.Chrome)
      @chrome.selected = true
    end
    if (preferred == Browser.None)
      @no_browser.selected = true
    elsif (preferred == Browser.Default)
      @default_browser.selected = true
    end

  #@gen_pane = PrototypeGeneralPane.new
    if (Axure::Platform::AxPlatform.Features.SupportsChm)
      @pane_names = ["PrototypeGeneralPane", "PrototypePagesPane", "PrototypeNotesPane", "PrototypeAnnotationsPane", "PrototypeInteractionsPane", "PrototypeSkinningPane", "PrototypeMobilePane", "PrototypeDistributionPane",
                     "PrototypeAdvancedPane", "PrototypeDiscussPane"]
    else
      @pane_names = ["PrototypeGeneralPane", "PrototypePagesPane", "PrototypeNotesPane", "PrototypeAnnotationsPane", "PrototypeInteractionsPane",
                     "PrototypeSkinningPane", "PrototypeMobilePane", "PrototypeAdvancedPane", "PrototypeDiscussPane"]
      @list.remove_item(@list.GetControlAtIndex(7))
    end

    @pane_names_to_pane = {"PrototypeGeneralPane" => PrototypeGeneralPane.new}
    @list.selected_index = 0
  end

  def browser_selected_changed(sender, args)
    if (@default_browser.selected)
      InterfaceSettings.PreferredBrowser = Browser.Default
    elsif (@no_browser.selected)
      InterfaceSettings.PreferredBrowser = Browser.None
    elsif (@internet_explorer.selected)
      InterfaceSettings.PreferredBrowser = Browser.InternetExplorer
    elsif (@firefox.selected)
      InterfaceSettings.PreferredBrowser = Browser.Firefox
    elsif (@safari.selected)
      InterfaceSettings.PreferredBrowser = Browser.Safari
    elsif (@chrome.selected)
      InterfaceSettings.PreferredBrowser = Browser.Chrome
    end
  end

  # returns the pane associated with a name and creates it if necessary
  # this assumes that pane_name is a valid class name
  def get_pane(pane_name)
    pane = @pane_names_to_pane[pane_name]
    if !pane
      pane = Kernel.const_get(pane_name).new
      @pane_names_to_pane[pane_name] = pane
      pane.configuration = configuration
      pane.my_init if pane.respond_to?(:my_init)
    end
    pane
  end

  def panes
    @pane_names_to_pane.values
  end

  def dispose
    super
    panes.each { |pane| pane.dispose }
  end

  def selected_index_changed(sender, e)
    @group_box.text = sender.selected_item.text
    @group_box.clear_controls()
    @group_box.add_control(get_pane(@pane_names[sender.selected_index]))

    @browser_group_box.visible = @group_box.content.is_a?(PrototypeGeneralPane)
    @shared_project_box.visible = self.disable_package_edit && @group_box.content.is_a?(PrototypeGeneralPane)
  end

  def file_browse_override_button_clicked(sender, args)
    open_dialog = Axure::Platform::CommonDialogs::AxOpenFolderDialogInfo.new
    open_dialog.description = intl_str("Select the directory where the prototype will be created.")

    @override_folder_text_box.text = open_dialog.folder_name if open_dialog.show_dialog == AxDialogResult.o_k
  end

  def reset_override_folder_button_clicked
    @override_folder_text_box.text = AxPlatform.PlatformServices.GetDefaultPrototypePath() + SEP + configuration.temp_project_name
  end


  #region IPackageEditControl overrides
  def RefreshContent
    oldTempName = @configuration.TempProjectName
    oldOverrideDestinationFolder = @configuration.TempOverrideDestinationFolder
    oldOverrideDestination = @configuration.TempOverrideDestination
    oldGenerateUsingOverrideDestination = @configuration.TempGenerateUsingOverrideDestination

    newConfig = @client.CurrentFile.LoadPackage(@configuration.PackageId, @configuration.TypeName)

    newConfig.TempOverrideDestinationFolder = oldOverrideDestinationFolder
    newConfig.TempOverrideDestination = oldOverrideDestination
    newConfig.TempGenerateUsingOverrideDestination = oldGenerateUsingOverrideDestination
    newConfig.TempProjectName = oldTempName

    self.configuration = newConfig
  end

  def disable_package_edit=(value)
    super
    @shared_project_box.visible = self.disable_package_edit
  end

  #endregion IPackageEditControl overrides
end
