require 'aml'

class PrototypeGeneralPane < AML::Control
  attr_reader :configuration
  bindable_attr_writer :configuration

  def initialize()
    initialize_component('dialogs/generators/html_prototype_dlg/general_pane.aml')
  end

  def my_init()
    if (configuration.destination_folder.length == 0)
      reset_folder
    end
  end

  def file_browse_button_clicked(sender, args)
    open_dialog = Axure::Platform::CommonDialogs::AxOpenFolderDialogInfo.new
    open_dialog.description = intl_str("Select the directory where the prototype will be created.")

    @folder_text_box.text = open_dialog.folder_name if open_dialog.show_dialog == AxDialogResult.o_k
  end

  def reset_folder
    @folder_text_box.text = AxPlatform.PlatformServices.GetDefaultPrototypePath() + SEP + configuration.temp_project_name
  end

  def reset_folder_button_clicked
    reset_folder
  end
end
