require 'aml'

class PrototypeDistributionPane < AML::Control
  attr_reader :configuration
  bindable_attr_writer :configuration

  def initialize()
    initialize_component('dialogs/generators/html_prototype_dlg/distribution_pane.aml')
  end

  def my_init()
    path = InterfaceSettings.hhc_path
    if(path == "hhc.exe path not specified" && System::IO::File.exists(intl_str("C:/Program Files/HTML Help Workshop/hhc.exe")))
      InterfaceSettings.hhc_path = intl_str("C:/Program Files/HTML Help Workshop/hhc.exe")
    end

    @location_label.text = InterfaceSettings.hhc_path 
  end

  def locate_hhc_clicked(sender, e)
    open_dialog = Axure::Platform::CommonDialogs::AxOpenFileDialogInfo.new
    open_dialog.filter = intl_str("Executable (*.exe)|*.exe")

    InterfaceSettings.hhc_path = open_dialog.file_name if open_dialog.show_dialog() == AxDialogResult.o_k
    @location_label.text = InterfaceSettings.hhc_path
#    @location_label.invalidate()
  end

  def help_clicked(sender, e)
    System::Diagnostics::Process.Start(
            "http://www.microsoft.com/downloads/details.aspx?FamilyID=00535334-c8a6-452f-9aa0-d597d16580cc&DisplayLang=en")
  end
end