require 'aml'

include Axure::Client::ToolBoxes::Components
include Axure::Client::ToolBoxes::Components::PagesAndMasters

class CSVMastersPane < AML::Control
  attr_reader :config
  bindable_attr_writer :config

  def my_init()
    @exclude_custom_widgets.selected = !config.include_custom_widget_masters
  end

  def initialize()
    initialize_component('dialogs/generators/csv_gen_dlg/masters_pane.aml')
  end

  def generate_all_selected_changed
    if @generate_all_button.selected: @tree_grid.enabled = false
    else @tree_grid.enabled = true
    end
  end

  def exclude_custom_widgets_selected_changed
    config.include_custom_widget_masters = !@exclude_custom_widgets.selected
  end

  def check_all_clicked
    @master_tree.check_all
  end

  def uncheck_all_clicked
    @master_tree.uncheck_all
  end

  def check_all_children_clicked
    node = @master_tree.current_node
    if (node != nil)
      @master_tree.check_children(node)
    end
  end

  def uncheck_all_children_clicked
    node = @master_tree.current_node
    if (node != nil)
      @master_tree.uncheck_children(node)
    end
  end

  def tree_checked_node_changed
    save_tree()
  end

  def tree_current_node_changed
    #node = @master_tree.current_node
  end

  def save_tree
    self.config.master_ids_to_generate = @master_tree.checked_ids
  end
end