require 'aml'

class CSVGeneralPane < AML::Control
  attr_reader :config, :generate_page_report, :generate_object_report
  bindable_attr_writer :config

  def initialize()
    initialize_component('dialogs/generators/csv_gen_dlg/general_pane.aml')
  end

  def my_init()
    if (config.page_report_path.length == 0)
      @page_report_file.text = AxPlatform.PlatformServices.GetDefaultReportPath() + SEP + config.temp_project_name + intl_str("_PagesAndMasters.csv")
    end

    if (config.object_report_path.length == 0)
      @object_report_file.text = AxPlatform.PlatformServices.GetDefaultReportPath() + SEP + config.temp_project_name + intl_str("_Objects.csv")
    end
  end

  def page_report_browse
    save_dialog = Axure::Platform::CommonDialogs::AxSaveFileDialogInfo.new
    save_dialog.filter = intl_str("CSV File (*.csv)|*.csv")

    @page_report_file.text = save_dialog.file_name if save_dialog.show_dialog == AxDialogResult.o_k
  end

  def object_report_browse
    save_dialog = Axure::Platform::CommonDialogs::AxSaveFileDialogInfo.new
    save_dialog.filter = intl_str("CSV File (*.csv)|*.csv")

    @object_report_file.text = save_dialog.file_name if save_dialog.show_dialog == AxDialogResult.o_k
  end
end