require 'aml'
require 'dialogs/generators/csv_gen_dlg/general_pane'
require 'dialogs/generators/csv_gen_dlg/pages_pane'
require 'dialogs/generators/csv_gen_dlg/masters_pane'
require 'dialogs/generators/csv_gen_dlg/notes_pane'
require 'dialogs/generators/csv_gen_dlg/annotations_pane'

require 'dialogs/package_edit_control.rb'

include Axure::Platform::WindowlessControls

class CSVGenerationDialog < PackageEditControl
  attr_reader :config
  bindable_attr_writer :config

  def configuration=(value)
    @config = value
    @panes.each do |x|
      x.config = value
      x.my_init() if x.respond_to?(:my_init)
    end

    @package_object = @config
    @dialog_info["configuration"] = @config
  end

  def dialog_info=(value)
    @dialog_info = value
    self.configuration = value["configuration"]
    value.before_shown.add(lambda { @list.focus })
    value.before_close.add(lambda { SaveContent() })

    value.default_size = AxSizeF.new(550,320)
    value.min_size = AxSizeF.new(550,320)
  end

  def initialize()
    initialize_component('dialogs/generators/csv_gen_dlg/csv_gen_dlg.aml')
    @panes = [CSVGeneralPane.new, CSVPagesPane.new, CSVMastersPane.new, CSVNotesPane.new, CSVAnnotationsPane.new]
    @list.selected_index = 0
  end

  def dispose
    super
    @panes.each { |pane| pane.dispose }
  end

  def selected_index_changed(sender, e)
    @group_box.text = sender.selected_item.text
    @group_box.clear_controls()
    @group_box.add_control(@panes[sender.selected_index])
  end

  #region IPackageEditControl overrides
  def RefreshContent
    oldTempName = @config.TempProjectName;
    newConfig = @client.CurrentFile.LoadPackage(@config.PackageId, @config.TypeName);
    newConfig.TempProjectName = oldTempName;

    self.configuration = newConfig;
  end
  #endregion IPackageEditControl overrides
end
