require 'aml'
require 'axure_enumerable'
require 'Model'

include Axure::Platform::Controls

include Axure::Client::Interaction
include Axure::Client::WindowlessControls

include Axure::DocumentModel
include Axure::DocumentModel::Interaction

class FeedbackDialog < AML::Control
	def initialize()
		initialize_component('dialogs/feedback_dlg/feedback_dlg.aml')
		self.size = AxSize.new(200, 100)
	end

	def dialog_info=(_info)
        @dialog_info = _info

        if (_info.exception != nil)
            @title_label.Text = intl_str("An error has occured. Click submit to report the error. Providing an email address is optional but will allow us to respond with a solution or workaround.")
            @recover_label.ForeColor = Axure::Platform::Drawing::AxColor.Red
            @recover_label.Text = intl_str("If you are unable to save your file due to this error, use File->Recover File to recover the latest AutoSaved version.")
            @message_label.Text = intl_str("Please provide additional information about how the error occurred.")
            @message_textbox.Text = _info.exception.Message + "\r\n\r\n" + @message_textbox.Text;
        end
	end

    def email_textbox_textchanged(sender, event_args)
        @dialog_info.email = @email_textbox.text
    end

    def message_textbox_textchanged(sender, event_args)
        @dialog_info.message = @message_textbox.text
    end
end
