require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'
require 'Core'

include System::IO
include Axure::IO

include Axure::Platform::Controls

include Axure::Client::Interaction
include Axure::Client::WindowlessControls

include Axure::DocumentModel
include Axure::DocumentModel::Interaction

class ExportImagesDialog < AML::Control
	def initialize()
		initialize_component('dialogs/export_images_dlg/export_images_dlg.aml')
	end

	def dialog_info=(_info)
        @dialog_info = _info
        _info.default_size = AxSizeF.new(350,70)
        _info.min_size = AxSizeF.new(300,70)
        _info.before_close.add(lambda { |s, e| before_close(s,e) })

        @folder_text_box.text = _info.destination_folder
	end

    def file_browse_button_clicked(s, e)
        open_dialog = Axure::Platform::CommonDialogs::AxOpenFolderDialogInfo.new
        open_dialog.description = intl_str("Select the directory where the images will be exported.")
        @folder_text_box.text = open_dialog.folder_name if open_dialog.show_dialog == AxDialogResult.o_k
    end

    def before_close(s, e)
      if(@dialog_info.dialog_result == AxDialogResult.OK)
        if (get_extension.length == 0)
          AxPlatform.PlatformServices.ShowMessageBox(intl_str("Please select an image format before continuing."),   intl_str("Alert"), AxMessageBoxButtons.OK)
          e.handled = true
          return
        end

        destination_folder = @folder_text_box.text
        if (destination_folder.length == 0)
          AxPlatform.PlatformServices.ShowMessageBox(intl_str("Please select a target folder before continuing."),   intl_str("Alert"), AxMessageBoxButtons.OK)
          e.handled = true
          return
        end

        @dialog_info.extension = get_extension
        @dialog_info.destination_folder = destination_folder
      end
    end

    def get_extension
      ext = @image_format_selectlist.Text;
      if (ext.Length > 0)
          return ext.slice(ext.index(".") + 1, 3);
      else
          return ext
      end
    end
end
