require 'aml'
require 'Model'
require 'PowerCollections'
require 'interop'

include Wintellect::PowerCollections
include Axure::DocumentModel

class DynamicPanelStateManager < AML::Control
  attr_reader :config, :states
  bindable_attr_writer :config, :states

  def dialog_info=(value)
    @info = value
    value.default_size = AxSizeF.new(400,320)
    value.min_size = AxSizeF.new(300,200)
    value.before_shown.add(lambda { @label_text_box.focus })

    my_init()
  end

  def initialize()
    initialize_component('dialogs/dynamic_panels/state_manager_dlg.aml')
  end

  def my_init()

    self.config = @info["configuration"]
    config.diagram_to_edit_index = -1
    set_allow_edit()

    @name_to_panels = List[Pair[System::String, PanelDiagram]].new
    config.name_to_panel_diagram_list = @name_to_panels
    @states.suspend_layout()
    config.panel_to_edit.panel_diagrams.each do |panel|
      @name_to_panels.add(Pair[System::String, PanelDiagram].new(panel.name, panel))
      @states.add_string_item(panel.name)
    end
    @states.resume_layout()
    set_remove_button_tool_tip
    set_allow_edit
  end

  def set_allow_edit()
    if(config.allow_edit)
      @binder.add_binding_expr(@remove_button, "Enabled", "states.remove_button_enabled", true, false)
      @binder.add_binding_expr(@up_button, "Enabled", "states.up_button_enabled", true, false)
      @binder.add_binding_expr(@down_button, "Enabled", "states.down_button_enabled", true, false)
    else
      @add_button.enabled = false
      @up_button.enabled = false
      @down_button.enabled = false
      @remove_button.enabled = false
      @label_text_box.enabled = false
      @states.allow_edit = false
    end
  end

  def add_button_clicked
    next_name = next_name(intl_str("State") ,@states.string_items)
    index = @states.insertion_index
    @name_to_panels.insert(index, Pair[System::String, PanelDiagram].new(next_name, nil))
    @states.insert_string_item(index, next_name)
    @states.selected_index = index
    @states.edit_selected_item()
  end

  def remove_button_clicked
    if(@states.get_control_count() == 1)
      AxPlatform.platform_services.show_message_box(intl_str(
      "There must be at least one panel state on the dynamic panel."), intl_str("Warning"), AxMessageBoxButtons.o_k)
    else
      @name_to_panels.remove_at(@states.selected_index)
      @states.remove_item(@states.selected_item)
      @states.refresh_selection

      set_remove_button_tool_tip
    end
  end

  def up_button_clicked
    selected_index = @states.selected_index
    item = @name_to_panels[selected_index]
    @name_to_panels.remove(item)
    @name_to_panels.insert(selected_index - 1, item)
    @states.move_up()
  end

  def down_button_clicked
    selected_index = @states.selected_index
    item = @name_to_panels[selected_index]
    @name_to_panels.remove(item)
    @name_to_panels.insert(selected_index + 1, item)
    @states.move_down()
  end

  def edit_button_clicked
    @config.diagram_to_edit_index = @states.selected_index
    @info.click_ok
  end

  def states_item_selected(sender, e)
    e.Handled = true
    @config.diagram_to_edit_index = @states.get_control_index(e.control)
    @info.click_ok
  end

  def edit_all_button_clicked
    @config.edit_all_diagrams = true
    @info.click_ok
  end

  def states_selected_index_changed
    set_remove_button_tool_tip
  end

  def set_remove_button_tool_tip
    if(!@states.selected_item || @states.get_control_count > 1 || !config.allow_edit): @remove_button.tool_tip = intl_str("Remove State")
    else @remove_button.tool_tip = intl_str("There must be at least one panel state on the dynamic panel.")
    end
  end

  def states_edit_finished(sender, e)
    control = e.control
    new_name = control.get_attached_property(ListPanel[].EDITING_TEXT)
    old_name = control.text

    return if new_name == old_name

    if(!is_valid_name(new_name))
#      AxPlatform.platform_services.show_message_box(intl_str("The name is invalid. Please try again."))
#      control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
      if AxPlatform.PlatformServices.ShowMessageBox(
              intl_str("The name is invalid. Please use another.\nClick Cancel or Press Esc while editing to revert the name"),
              intl_str("Invalid Name"), AxMessageBoxButtons.o_k_cancel) == AxDialogResult.o_k
        e.Handled = false
      else e.control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
      end
    else
      temp = @name_to_panels[@states.selected_index]
      @name_to_panels[@states.selected_index] = Pair[System::String, PanelDiagram].new(new_name, temp.second)
      control.text = new_name
    end
  end

  def is_valid_name(name)
    !name.contains("/")
  end
end