require 'aml'
require 'Model'

include Axure::Client::Interaction
include Axure::DocumentModel::Interaction

class PinToDialog < AML::Control
  attr_reader :info
  bindable_attr_writer :info

  def initialize()
    initialize_component('dialogs/dynamic_panels/pin_to_dlg.aml')
  end

  def dialog_info=(_info)
    self.info = _info

    info.default_size = AxSizeF.new(400,300)
    info.min_size = AxSizeF.new(400,300)

    info.before_close.add(lambda {
      info.pin_to_object = @dynamic_panel_selector.selected_path
      info.collapse_easing = @easing_select_list.selected_index
      info.collapse_duration = @duration_number_box.value
    })

    @dynamic_panel_selector.root_diagram = self.info.root_diagram
    @dynamic_panel_selector.dynamic_panel_selectable = true
    @dynamic_panel_selector.include_objects_in_dynamic_panel = false
    @dynamic_panel_selector.path_filter = self.info.path_filter

    if (self.info.pin_to_object)
      @dynamic_panel_selector.selected_path = self.info.pin_to_object
    end

    @easing_select_list.string_items = InteractionMoveWidgetAction.GetAllEasingFriendlyStrings()

    @easing_select_list.selected_index = info.collapse_easing
    @duration_number_box.value = info.collapse_duration

    if (@easing_select_list.selected_index < 1)
        @duration_number_box.enabled = false
    end
  end

  def easing_select_list_item_selected(sender, event_args)
    @duration_number_box.enabled = @easing_select_list.selected_index >= 1
  end

  def clear_button_clicked(sender, e)
    @dynamic_panel_selector.selected_path = nil
  end
end