
require 'aml'
require 'Model'

require 'dialogs/package_edit_control'

include Axure::Platform::WindowlessControls
include Axure::Client::WindowlessControls
include Axure::DocumentModel

class CustFieldsDialog < PackageEditControl
  attr_reader :dialog_info, :fields_grid, :views, :current_fields
  bindable_attr_writer :dialog_info, :fields_grid, :views, :current_fields

	def field_set=(value)
    @field_set = value

		@package_object = @field_set

    @prop_key = @field_set.property_key
    @view_key = @field_set.annotation_field_views

    my_init()
	end

  def dialog_info=(value)
    @dialog_info = value

    @dialog_info.default_size = AxSizeF.new(475,320)
    @dialog_info.min_size = AxSizeF.new(475,320)
    @dialog_info.before_shown.add(lambda {
      @fields_grid.set_widths_proportional
      @tab_pane.selected_index = 1;
      @tab_pane.selected_index = 0;
      @current_fields.set_widths_proportional
    })
    @dialog_info.before_close.add(lambda { |sender, e|
      LoseFocus()
      e.Handled = @fields_grid.IsEditing || @views.IsEditing
    })

    self.field_set = dialog_info["fieldSet"]
  end

  def initialize()
    initialize_component('dialogs/cust_fields_dlg/cust_fields_dlg.aml')
  end

  def my_init()
    suspend_layout()
    @fields_grid.set_column_editable(0, true)
    #@add_select_list.set_picture(ImageListContainer.toolbar_icons.images["plus"])
    #@current_select_list.set_picture(ImageListContainer.toolbar_icons.images["plus"])

    reset_fields()
    reset_views()

    resume_layout()
  end

  def reset_fields()
    @fields_grid.suspend_layout()
    @fields_grid.clear_controls()

    @prop_key.key_names.each do |item|
      @fields_grid.add_item(item, DocumentDataTypeFunctions.get_internationalized_string(
              @prop_key.get_property_data_type(item)))
    end
    @fields_grid.resume_layout()

    reset_current_fields()
  end

  def view_names()
    view_names = System::Collections::Generic::List[System::String].new
    @view_key.each do |view|
      view_names << System::String.new(view.name)
    end
    view_names
  end

  def get_view_from_name(name)
    @view_key.each do |view|
      return view if view.name == name
    end
  end

  def reset_views()
    @views.suspend_layout()
    @views.clear_controls()
    @views.string_items = view_names()
    @views.resume_layout()
  end

  def fields_selected_index_changed(sender, e)
    enabled = @fields_grid.selected_index >= 0
#    @remove_button.enabled = enabled
#    @up_button.enabled = enabled
#    @down_button.enabled = enabled

    if enabled && @fields_grid.selected_item.get_control_at_index(1).text == intl_str("SelectList")
      @select_list_group_box.enabled = true
      name = @fields_grid.selected_item.get_control_at_index(0).text
      @select_list_text_box.text = @prop_key.get_property_select_list_text(name)
    else
      @select_list_group_box.enabled = false
      name = "Select List"
      @select_list_text_box.text = ""
    end
    @select_list_group_box.text = "Edit: " + name
  end

  def field_edit_finished(sender, e)
    control = e.control
    new_name = control.get_attached_property(ListPanel[].EDITING_TEXT)
    old_name = control.text
    return if new_name == old_name

    if(!is_valid_name(new_name, @prop_key.key_names))
      if AxPlatform.PlatformServices.ShowMessageBox(
              intl_str("The field name is in use or reserved. Please use another.\nClick Cancel or Press Esc while editing to revert the name"),
              intl_str("Invalid Name"), AxMessageBoxButtons.o_k_cancel) == AxDialogResult.o_k
        e.Handled = false
      else e.control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
      end
    else
      @prop_key.rename_property(old_name, new_name)
#      i can't do this through the normal reset_fields method because it might mess up the scroll
#      reset_fields()
      reset_current_fields()
      control.text = new_name
    end
  end

  def view_edit_finished(sender, e)
    control = e.control
    new_name = control.get_attached_property(ListPanel[].EDITING_TEXT)
    old_name = control.text
    return if new_name == old_name

    if(!is_valid_name(new_name, view_names()))
      if AxPlatform.PlatformServices.ShowMessageBox(
              intl_str("The view name is in use or reserved. Please use another.\nClick Cancel or Press Esc while editing to revert the name"),
              intl_str("Invalid Name"), AxMessageBoxButtons.o_k_cancel) == AxDialogResult.o_k
        e.Handled = false
      else e.control.set_attached_property(ListPanel[].EDITING_TEXT, old_name)
      end
    else
      get_view_from_name(old_name).name = new_name
#      i can't do this through the normal reset_fields method because it might mess up the scroll
#      reset_fields()
      control.text = new_name
    end
  end

  def select_list_text_box_text_changed(sender, e)
    #this is null if all the fields have been deleted and we are just clearing the text
    if @fields_grid.selected_item
      name = @fields_grid.selected_item.get_control_at_index(0).text
      @prop_key.set_property_select_list_text(name, @select_list_text_box.text)
    end
  end

  # This is so stupid. On Windows when you hit enter a command key is thrown and then a
  # regular key press. Since something else is listening to the command key and exiting
  # the dialog when it sees enter and the windows text box doesn't react to enter until
  # the key press event, I have to catch the enter on the command key press and handle
  # it manually to prevent the other item from exiting the dialogue.
#  def select_list_text_box_cmd_key(sender, e)
#    if e.key_data == AxKeys.enter
#      @select_list_text_box.insert_text("\r\n")
#      e.handled = true
#    end
#  end

  def add_select_list_item_selected(sender, e)
    return if !e.control
    data_type = case e.control.text
#      when intl_str("Text"): DocumentDataType.text
      when intl_str("Number"): DocumentDataType.number
      when intl_str("Date"): DocumentDataType.date
      when intl_str("Select List"): DocumentDataType.select_list
      else DocumentDataType.text
    end
    @add_select_list.highlighted_item = nil
    @add_select_list.text = intl_str("Add")
    name = next_name(intl_str("New Field"), @prop_key.key_names)

    @prop_key.add_property(name, data_type)
    reset_fields()

    @fields_grid.selected_index = @fields_grid.get_control_count() - 1
    @fields_grid.edit_selected_item()
  end

  def is_valid_name(name, name_array)
    return false if name.empty?() || name.include?("\"") ||
            name.casecmp("ID") == 0 || name.casecmp(intl_str("Label")) == 0 || name.casecmp(intl_str("Link")) == 0 ||
            name.casecmp(intl_str("Interactions")) == 0 || name.casecmp(intl_str("Widget Text")) == 0 ||
            name.casecmp(intl_str("Widget Tooltip")) == 0 || name.casecmp(intl_str("Footnote")) == 0

    name_array.each do |val|
      return false if name == val
    end

    return true
  end

  def remove_button_clicked(sender, e)
    if AxPlatform.platform_services.show_message_box(
          intl_str("Are you sure you want to delete this field?\nIt cannot be undone."),
          intl_str("Warning"), AxMessageBoxButtons.YesNo) == AxDialogResult.yes

      @prop_key.delete_property(@fields_grid.selected_item.get_control_at_index(0).text)
      reset_fields()

      @fields_grid.refresh_selection()
    end
  end

  def up_button_clicked(sender, e)
    old_index = @fields_grid.selected_index
    if @prop_key.move_property(@fields_grid.selected_item.get_control_at_index(0).text,-1)
      reset_fields()
      @fields_grid.selected_index = old_index - 1
    end
  end

  def down_button_clicked(sender, e)
    old_index = @fields_grid.selected_index
    if @prop_key.move_property(@fields_grid.selected_item.get_control_at_index(0).text,1)
      reset_fields()
      @fields_grid.selected_index = old_index + 1
    end
  end

  def view_add_button_clicked(sender, e)
    view = AnnotationFieldView.new(@prop_key.owner)

    view.name = next_name(intl_str("New View"), view_names())

    @view_key.add(view)
    reset_views()

    @views.selected_index = @views.get_control_count() - 1
    @views.edit_selected_item()
  end

  def view_remove_button_clicked(sender, e)
    @view_key.remove(get_view_from_name(@views.selected_item.text))
    reset_views()
    @views.refresh_selection()
  end

  def view_up_button_clicked(sender, e)
    time = Time.now
    view = get_view_from_name(@views.selected_item.text)
    index = @view_key.index_of(view)

    if(index > 0)
      new_index = index - 1
      @view_key.remove(view)
      @view_key.insert(new_index, view)

      reset_views()
      @views.selected_index = new_index
    end
  end

  def view_down_button_clicked(sender, e)
    view = get_view_from_name(@views.selected_item.text)
    index = @view_key.index_of(view)

    if(index < @view_key.count - 1)
      new_index = index + 1
      @view_key.remove(view)
      @view_key.insert(new_index, view)

      reset_views()
      @views.selected_index = new_index
    end
  end

  def reset_current_fields()
    @current_fields.suspend_layout()
    @current_fields.clear_controls()
#    view = get_view_from_name(@views.selected_item.text)

    if @current_view
      @current_view.property_names.each do |prop|
        item = prop.name
        @current_fields.add_item(item, DocumentDataTypeFunctions.get_internationalized_string(
                @prop_key.get_property_data_type(item)))
      end
      @current_select_list.string_items = fields_not_in_current_view()
    end
    @current_fields.resume_layout()
  end

  def fields_not_in_current_view()
    fields = System::Collections::Generic::List[System::String].new
    @prop_key.property_names.each do |prop_name|
      fields << System::String.new(prop_name.name) if !@current_view.is_property_visible(prop_name)
    end
    fields
  end

  def views_selected_index_changed(sender, e)
#    selected_index = @views.selected_index;

    enabled = @views.selected_index >= 0
#    @view_remove_button.enabled = enabled
#    @view_up_button.enabled = enabled && selected_index > 0
#    @view_down_button.enabled = enabled && selected_index < @views.get_control_count() - 1
    @current_group_box.enabled = enabled

    if enabled
      @current_view = get_view_from_name(@views.selected_item.text)
      @current_group_box.text = intl_str("Fields in ") + @current_view.name

      reset_current_fields()
    else
      @current_view = nil
      @current_group_box.text = intl_str("Fields in Current View")
    end
    @current_fields.selected_index = -1
    @current_group_box.invalidate()
  end

  def current_select_list_item_selected(sender, e)
    @current_view.add_property_key_item(@prop_key.get_property_key_item(e.control.text))
    reset_current_fields()
    @current_select_list.text = intl_str("Add")
  end

  def current_selected_index_changed
#    enabled = @current_fields.selected_index >= 0
#    @current_remove_button.enabled = enabled
#    @current_up_button.enabled = enabled
#    @current_down_button.enabled = enabled
  end

  def current_remove_button_clicked(sender, e)
    prop_name = @current_fields.selected_item.get_control_at_index(0).text
    @current_view.remove_property_key_item(@prop_key.get_property_key_item(prop_name))
    reset_current_fields()
    @current_fields.refresh_selection()
  end

  def current_up_button_clicked(sender, e)
    old_index = @current_fields.selected_index
    field = @prop_key.get_property_key_item(@current_fields.selected_item.get_control_at_index(0).text)
    if @current_view.move_property_key_item(field, -1)
      reset_current_fields()
      @current_fields.selected_index = old_index - 1
    end
  end

  def current_down_button_clicked(sender, e)
    old_index = @current_fields.selected_index
    field = @prop_key.get_property_key_item(@current_fields.selected_item.get_control_at_index(0).text)
    if @current_view.move_property_key_item(field, 1)
      reset_current_fields()
      @current_fields.selected_index = old_index + 1
    end
  end

	#region IPackageEditControl overrides
	def RefreshContent
		@client.CurrentFile.Refresh();
		self.field_set = @client.Document.DiagramObjectAnnotationFieldSet;
	end

	def SaveContent
		super

		@client.CurrentFile.Refresh();
	end
	#endregion IPackageEditControl overrides


end
