require 'aml'
require 'axure_enumerable'
require 'Model'
require 'interop'


class AuthenticationDialog < AML::Control
    
	def initialize()
		#allow AlignPadLayouPanel to size up to its containing control
		self.auto_size = true

		initialize_component("dialogs/authentication_dialog.aml")
	end

	def dialog_info=(info)
		@dialog_info = info

		info.before_close.add(lambda {|s, ce| 
			info["Password"] = @password_textbox.password
			info["Username"] = @username_textbox.text
			info["MaySave"] = @maysave_checkbox.selected
		})

		@realm_label.text = info["Realm"]
		@username_textbox.text = info["Username"]

        info.default_size = AxSizeF.new(500,130)
        info.min_size = AxSizeF.new(400,100)        
        info.title = intl_str("Authenticate")

        info.before_shown.add(lambda{@username_textbox.focus})
	end

end
