require 'aml'

include Axure::Client::WindowlessControls

class AddManyDialog < AML::Control
  attr_accessor :dialog_info

  def dialog_info=(info)
    @dialog_info = info

    info.default_size = AxSizeF.new(250,300)
    info.min_size = AxSizeF.new(250,250)

    dialog_info.before_shown.add(lambda { @list_text_textbox.focus })
    dialog_info.before_close.add(lambda {
      @dialog_info.set_property("list_text", @list_text_textbox.text)
    })
  end

  def initialize()
    initialize_component('dialogs/add_many_dlg/add_many_dlg.aml')
  end

end