require 'aml'
require 'Model'

include Axure::Platform::Drawing

include Axure::DocumentModel
include Axure::DocumentModel::DiagramEditor

class PagePropertiesEditorImpl < AML::Control
	def initialize()
		self.auto_size = true

		initialize_component("controls/page_properties_editor.aml")
	end

	def outer_page_fragment
		return nil if !@client.outer_object
		return @client.outer_object if @client.outer_object.is_a?(PackageObject)
		return @client.outer_object.owner
	end

	def dialog_info=(_info)
		@client = _info["Client"]
		@client.outer_object_changed.add(lambda {
			page = outer_page_fragment
			if page
				@sketchy_checkbutton.selected = page.DiagramObjectRenderMode == DiagramObjectRenderMode.Sketchy
		 	 	@squiggle_slider.Value = page.BorderSquiggle * 20
		 	 	@saturation_slider.Value = page.FillSaturation * 100;
			end
		})
	end

	def sketchy_checkbutton_selected_changed
		page = outer_page_fragment

		if page
			page.DiagramObjectRenderMode = @sketchy_checkbutton.Selected ? DiagramObjectRenderMode.Sketchy : DiagramObjectRenderMode.Normal
		end
	end

	def squiggle_slider_scroll
		page = outer_page_fragment
		if page
			page.BorderSquiggle = @squiggle_slider.Value/20.0
		end
		@squiggle_demo.invalidate
	end

	def saturation_slider_scroll
		page = outer_page_fragment
		if page
			page.FillSaturation = @saturation_slider.Value/@saturation_slider.Maximum.to_f
		end
		@saturation_demo.invalidate
	end

	def squiggle_demo_paint (s,e)
		gfx = e.graphics
		gfx.draw_rectangle(AxPens.Blue,@squiggle_demo.display_rectangle);

		sketchy_gfx = SketchyGraphics.new(gfx)
		sketchy_gfx.Squiggle = @squiggle_slider.Value/20.0
		sketchy_gfx.draw_line(AxPens.Black, 0, 10, 70, 10)
	end

	def saturation_demo_paint (s,e)
		gfx = e.graphics
		gfx.draw_rectangle(AxPens.Red,@saturation_demo.display_rectangle);

		sketchy_gfx = SketchyGraphics.new(gfx)
		sketchy_gfx.Squiggle = 0;
		sketchy_gfx.Saturation = @saturation_slider.Value/@saturation_slider.Maximum.to_f

		sketchy_gfx.fill_rectangle(AxBrushes.Red, 5, 5, 10, 10)
		sketchy_gfx.fill_rectangle(AxBrushes.Orange, 20, 5, 10, 10)
		sketchy_gfx.fill_rectangle(AxBrushes.Yellow, 35, 5, 10, 10)
		sketchy_gfx.fill_rectangle(AxBrushes.Green, 5, 20, 10, 10)
		sketchy_gfx.fill_rectangle(AxBrushes.Blue, 20, 20, 10, 10)
		sketchy_gfx.fill_rectangle(AxBrushes.Purple, 35, 20, 10, 10)
	end
end
